<div class="space-in-lg bg-white b-b">
    <h2 class="h3 text-info row-space-2"><?php _e("Plugins", "themekitchen"); ?></h2>
    <p class="text-muted row-space-0">
        <?php _e("Use this theme to 100% of its features with our compatible and already integrated plugins.", "themekitchen"); ?>
    </p>
</div>
<div class="bg-light lt">
    <div class="p-lg b-b">
        <p>This theme has been designed to work with our awesome and carefully plugins. Whether you want a nice and powerful messaging system, a Facebook Login integration or let your users have profile pictures... <span class="font-bold">you won't have to write a line of code</span>. Download and enjoy!</p>
    </div>
    <div class="bg-light b-b p-lg text-center text-lg">
        <span>
            Made in Paris, France with
            <i class="ion-coffee"></i>
            <i class="ion-music-note"></i>
            <i class="ion-beer"></i>
        </span>
        /
        <span><i class="ion-heart text-danger"></i>&nbsp;Thanks for supporting us!&nbsp;<i class="ion-heart text-danger"></i></span>
    </div>
    <?php
        $plugins = array(
            array(
                "s_name" => "Madhouse Messenger",
                "s_slug" => "madhouse_messenger",
                "s_icon" => Madhouse_ThemeKitchen_Package::getURL("assets/img/messenger.jpg"),
                "s_excerpt" => "The famous messaging system that transform your Osclass in a social network!",
                "s_description" => "Messenger is the ultimate personal messaging plugin for your Osclass website, simple as sending and responding to messages but gives you a lot more : conversations and unified inbox, read receipts, permalinks and a complete set of administration pages.",
                "s_download_url" => "http://market.osclass.org/plugins/messaging/madhouse-messenger_175",
            ),
            array(
                "s_name" => "Madhouse SEO",
                "s_slug" => "madhouse_seo",
                "s_icon" => Madhouse_ThemeKitchen_Package::getURL("assets/img/seo.jpg"),
                "s_excerpt" => "Madhouse SEO plugin lets you ",
                "s_description" => "Improve greatly the ranking of your website in search engines results by customizing meta-title, meta-description and h1 title of each and every pages of your pages. As usual, you won't need to do any code modification, the plugin is fully integrated.",
                "s_download_url" => "https://market.osclass.org/plugins/seo/madhouse-seo_637",
            ),
            array(
                "s_name" => "Madhouse Avatar",
                "s_slug" => "madhouse_avatar",
                "s_icon" => Madhouse_ThemeKitchen_Package::getURL("assets/img/avatar.jpg"),
                "s_excerpt" => "Add profile pictures for your users to your Osclass!",
                "s_description" => "Right out of the box, this plugin is already connected to most of the hooks and enables your users instantly upload a profile pictures at registration or when editing their profile without you getting into the code.",
                "s_download_url" => "http://market.osclass.org/plugins/user-management/madhouse-avatar_187",
            ),
            array(
                "s_name" => "Madhouse Facebook",
                "s_slug" => "madhouse_facebook",
                "s_icon" => Madhouse_ThemeKitchen_Package::getURL("assets/img/facebook.jpg"),
                "s_excerpt" => "Facebook login integration plugin (and much more) for Osclass!",
                "s_description" => "Beyond a simple Facebook plugin, we have added some cool features that makes quite a difference from a regular Facebook plugin for Osclass: smart user management, publish items to user’s timeline / feed on Facebook and user’s profile picture synchronization.",
                "s_download_url" => "http://market.osclass.org/plugins/social-networks/madhouse-facebook_519",
            ),
            array(
                "s_name" => "Madhouse User Attributes",
                "s_slug" => "madhouse_user_attributes",
                "s_icon" => Madhouse_ThemeKitchen_Package::getURL("assets/img/user_attributes.jpg"),
                "s_excerpt" => "Custom attributes plugin to extend your Osclass users!",
                "s_description" => "Your Osclass website becomes more and more closer of a social website with this highly customizable custom attributes that extends your user fields including: firstname and lastname, birthday, gender, nationality, relationship status and more!",
                "s_download_url" => "https://market.osclass.org/plugins/attributes/madhouse-user-attributes_650",
            ),
        );
    ?>
    <div class="p-lg">
        <?php foreach ($plugins as $plugin) : ?>
            <?php
                echo mtk_render_twig(
                    "@admin/plugins/plugin-single",
                    array(
                        "plugin" => $plugin,
                        "is_installed" => osc_plugin_is_installed($plugin["s_slug"] . "/index.php"),
                    )
                );
            ?>
        <?php endforeach; ?>
    </div>
</div>