<?php

class Madhouse_ThemeKitchen_Services_SettingsService
{

    /**
     * Compiled datas from all modules.
     *
     * @var Array<string, Any>
     */
    protected $datas;

    /**
     * @TODO
     */
    public static function newInstance()
    {
        return new self(
            new Madhouse_ThemeKitchen_Models_Settings(),
            Madhouse_ThemeKitchen_Services_ModuleManager::newInstance(),
            Madhouse_ThemeKitchen_Services_ResourcesUploader::newInstance()
        );
    }

    /**
     * Constructor.
     */
    public function __construct($model, $moduleManager, $resourcesUploader)
    {
        $this->model = $model;
        $this->resourcesUploader = $resourcesUploader;
        $this->moduleManager = $moduleManager;
    }

    public function findSettingsBy($filters = null)
    {
        if (is_null($filters)) {
            $filters = array();
        }

        if (isset($filters["module"])) {
            // If module is defined.
            return $this->model->findSettingsByModule($filters["module"]);
        }

        // Compute all settings from modules.
        $computedSettings = new Madhouse_ThemeKitchen_Settings2();
        foreach ($this->moduleManager->getModules() as $module) {
            // Retrieve module settings @ database.
            $moduleSettings = $this->model->findSettingsByModule($module);

            // Add module settings to global settings.
            $computedSettings->set("$." . $module->getId(), $moduleSettings->toArray());
        }

        // Return the computed settings from all modules.
        return $computedSettings;
    }

    /**
     * Update the settings.
     *
     * @param  Madhouse_ThemeKitchen_ModuleBase $settings
     *
     * @return Madhouse_ThemeKitchen_ModuleBase
     *
     * @since  1.1.0
     */
    public function updateSettings($settings)
    {
        // Get current settings.
        $currentSettings = $this->findSettingsBy();

        foreach ($this->moduleManager->getModules() as $module)
        {
            // Update the module.
            $this->updateModule(
                $module,
                $currentSettings->getSubset($module->getId()),
                $settings->getSubset($module->getId())
            );
        }

        // Return the settings.
        return $this->findSettingsBy();
    }

    /**
     * Update the module settings.
     *
     * @param  Madhouse_ThemeKitchen_ModuleBase $module
     * @param  Madhouse_ThemeKitchen_Settings2  $moduleSettings
     * @param  Madhouse_ThemeKitchen_Settings2 $newModuleSettings
     *
     * @return Madhouse_ThemeKitchen_Settings2
     */
    public function updateModule($module, $moduleSettings, $newModuleSettings)
    {
        foreach ($module->getAssets() as $resource) {
            if ($resource["s_section"] !== "") {
                $folder = mtk_uploads_path($module->getId() . "-" . $resource["s_section"]);
            } else {
                $folder = mtk_uploads_path();
            }

            // Upload this resource.
            $this->resourcesUploader->process(
                $module,
                $resource,
                $moduleSettings,
                $newModuleSettings,
                $folder
            );
        }

        // @TODO
        foreach ($module->getSubsets() as $subset) {
            // Get the subset array.
            $subsetArray = $newModuleSettings->get("$." . $subset["s_section"]);

            // Resets keys at 0.
            $newModuleSettings->set("$." . $subset["s_section"], array_values($subsetArray));
        }

        // Run the module update.
        $module->update($newModuleSettings);

        // Set the settings @ database.
        $this->model->updateModule($module, $newModuleSettings);

        // Return updated settings;
        return $this->findSettingsBy();
    }

    /**
     * Refresh the settings.
     *
     * @return void.
     *
     * @since  1.2.0
     */
    public function refresh()
    {
        // Get all the settings.
        $currentSettings = $this->findSettingsBy();

        // Re-update all the modules.
        $modules = $this->moduleManager->getModules();
        foreach ($modules as $module) {
            // Get the module settings.
            $currentModuleSettings = $currentSettings->getSubset($module->getId());

            // Execute the module main method.
            $module->refresh($currentModuleSettings);
        }
    }
}
