<?php

use JsonPath\JsonObject as JsonObject;

/**
 * @TODO
 */
class Madhouse_ThemeKitchen_Services_ResourcesUploader
{
    /**
     * @TODO
     */
    public static function newInstance()
    {
        return new self();
    }

    public function __construct()
    {
    }

    public function process($module, $resource, $currentSettings, $settings, $folder)
    {
        // Get all files from Params.
        $files = $this->sanitizeFiles(Params::getParamsAsArray("files"));

        // Need to retrieve a subset.
        $store = new JsonObject($files);
        $query = implode(".", array_filter(array("$", $module->getId(), $resource["s_section"])));
        $res = $store->get($query);
        if (! $res) {
            return;
        }

        // Update $files with the subset found.
        $files = array_shift($res);

        if (count(array_filter(array_keys($files), 'is_string')) === 0) {
            // Subset.
            foreach ($files as $i => $f) {
                // Retrieve the subset item.
                $subsetItem = $settings->get(array($resource["s_section"], $i));

                $position = array("i_position" => $i);
                if (isset($subsetItem["i_previous_position"])) {
                    // Set the current position
                    $position["i_previous_position"] = $subsetItem["i_previous_position"];
                }

                // Upload this.
                $this->uploadSingle(
                    $f,
                    $folder,
                    $resource,
                    $settings,
                    $currentSettings,
                    "image-" . (isset($subsetItem["i_previous_position"]) ? $subsetItem["i_previous_position"] : $i) . "_@" . time(),
                    $position
                );
            }
        } else {
            // Single resource or localized resource.
            $this->uploadSingle($files, $folder, $resource, $settings, $currentSettings, $resource["s_field"] . "_@" . time());
        }

        return $settings;
    }

    public function uploadSingle($files, $folder, $resource, $settings, $currentSettings, $realname = null, $position = null)
    {
        // Sanitize $realname if exists ($name if not).
        if (is_null($realname)) {
            $realname = $resource["s_field"];
        }
        $realname = str_replace("_", "-", str_replace("s_", "", $realname));

        if (isset($files[$resource["s_field"]])) {
            /*
             * One image to upload.
             */
            $path = $this->_upload(
                $files[$resource["s_field"]],
                $folder,
                (isset($resource["formats"])) ? $resource["formats"] : array(),
                $realname
            );

            if (isset($position["i_previous_position"])) {
                // Set the path @ settings or the old value.
                if (is_null($path)) {
                    $path = $currentSettings->get(
                        array($resource["s_section"], $position["i_previous_position"]),
                        $resource["s_field"]
                    );
                }
                $settings->set(
                    array($resource["s_section"], $position["i_position"], $resource["s_field"]),
                    $path
                );
            } elseif (isset($position["i_position"])) {
                // Set the path @ settings or the old value.
                if (is_null($path)) {
                    $path = $currentSettings->get(
                        array($resource["s_section"], $position["i_position"]),
                        $resource["s_field"]
                    );
                }
                $settings->set(
                    array($resource["s_section"], $position["i_position"], $resource["s_field"]),
                    $path
                );
            } else {
                // Set the path @ settings or the old value.
                if (is_null($path)) {
                    $path = $currentSettings->get($resource["s_section"], $resource["s_field"]);
                }
                $settings->set(
                    array($resource["s_section"], $resource["s_field"]),
                    $path
                );
            }
        } else {
            /*
             * There's no image for $name, looking for each locales.
             */
            foreach (osc_get_locales() as $locale) {
                $path = $this->_upload(
                    $files["locale"][$locale["pk_c_code"]][$resource["s_field"]],
                    $folder,
                    (isset($resource["formats"])) ? $resource["formats"] : array(),
                    $realname . "-" . str_replace("_", "-", $locale["pk_c_code"])
                );

                if (isset($position["i_previous_position"])) {
                    // Set the path @ settings or the old value.
                    if (is_null($path)) {
                        $path = $currentSettings->get(
                            array($resource["s_section"], $position["i_previous_position"]),
                            $resource["s_field"],
                            $locale["pk_c_code"]
                        );
                    }
                    $settings->set(
                        array($resource["s_section"], $position["i_position"], "locale", $locale["pk_c_code"], $resource["s_field"]),
                        $path
                    );
                } elseif (isset($position["i_position"])) {
                    // Set the path @ settings or the old value.
                    if (is_null($path)) {
                        $path = $currentSettings->get(
                            array($resource["s_section"], $position["i_position"]),
                            $resource["s_field"],
                            $locale["pk_c_code"]
                        );
                    }
                    $settings->set(
                        array($resource["s_section"], $position["i_position"], "locale", $locale["pk_c_code"], $resource["s_field"]),
                        $path
                    );
                } else {
                    // Set path @ settings.
                    if (is_null($path)) {
                        $path = $currentSettings->get($resource["s_section"], $resource["s_field"], $locale["pk_c_code"], false);
                    }
                    $settings->set(
                        array($resource["s_section"], "locale", $locale["pk_c_code"], $resource["s_field"]),
                        $path
                    );
                }
            }
        }
    }

    public function _upload($raw, $folder, $formats, $newName = null)
    {
        if ($raw["tmp_name"] && $raw["error"] == UPLOAD_ERR_OK) {
            // Create folder if not exists.
            if (!is_dir($folder)) {
                if (!@mkdir($folder, 0755, true)) {
                    throw new Exception("UPLOAD #1");
                }
            }

            // Check size of this image.
            if (!$this->checkSize($raw)) {
                return null;
            }

            // Check type of this image.
            if (!$this->checkType($raw)) {
                return null;
            }

            // Keep the original name of the file if no name is requested.
            if (is_null($newName)) {
                $newName = $tmp["name"];
            }

            foreach ($formats as $formatName => $formatDimensions) {
                // Explode dimensions.
                list($width, $height) = explode('x', $formatDimensions);

                // Create the file, rotate and resize.
                $img = ImageResizer::fromFile($raw["tmp_name"])
                    ->autoRotate()
                    ->resizeTo($width, $height)
                ;

                // Save the file to a temporary location.
                $img->saveToFile($raw["tmp_name"] . "_" . $formatName);

                // Copy the file to target location.
                osc_copy(
                    $raw["tmp_name"] . "_" . $formatName,
                    sprintf('%s/%s.%s', $folder, $newName . "_" . $formatName, $img->getExt())
                );

                // Delete the temporary file.
                @unlink($raw["tmp_name"] . "_" . $formatName);
            }

            if (!in_array($raw["type"], array("image/vnd.microsoft.icon", "image/x-icon"))) {
                // Create an image instance for the original file.
                $img = ImageResizer::fromFile($raw["tmp_name"]);
                $imgExt = $img->getExt();
            } else {
                // Assume it's a favicon.
                $imgExt = "ico";
            }

            // Move the file into $targetPath.
            move_uploaded_file($raw["tmp_name"], sprintf('%s/%s.%s', $folder, $newName, $imgExt));

            // Return a proper array.
            return array(
                "s_path" => str_replace(osc_base_path(), '', $folder), // Relative path ie. oc-content/uploads/{theme}/{name}.{ext}
                "s_name" => $newName,
                "s_ext"  => $imgExt,
                "formats" => array_keys($formats),
            );
        }

        return null;
    }

    /**
     * Sanitize the $file array from $_FILES structure to a more logical one.
     *
     * @param  array $files
     *
     * @return array
     */
    public function sanitizeFiles($files)
    {
        // Transform the array.
        $arrayOfPaths = self::mapArrayToPaths($files);

        // Translates array into a list of strings (paths) & replaces things.
        $fixedArrayOfPaths = preg_replace(
            '#^(/[^/]+)(/name|/type|/tmp_name|/error|/size)([^\s]*)( = [^\n]*)#m',
            '\1\3\2\4',
            $arrayOfPaths
        );

        // Transforms the strings back to an array & returns it.
        return self::mapPathsToArray($fixedArrayOfPaths);
    }

    private function checkSize($aResources)
    {
        $success = true;

        if ($aResources != '') {
            // get allowedExt
            $maxSize = osc_max_size_kb() * 1024;

            $bool_img = false;
            if ($aResources["error"] == UPLOAD_ERR_OK) {
                $size = $aResources['size'];
                if ($size >= $maxSize) {
                    $success = false;
                }
            }

            if (!$success) {
                osc_add_flash_error_message(_m("One of the files you tried to upload exceeds the maximum size"), "admin");
            }
        }
        return $success;
    }

    private function checkType($aResources)
    {
        $success = true;
        require LIB_PATH . 'osclass/mimes.php';

        // Add .ico for favicon.
        $mimes["ico"] = array("image/vnd.microsoft.icon", "image/x-icon");

        if ($aResources != '') {
            // get allowedExt
            $aMimesAllowed = array();

            // Add .ico for favicon.
            $aExt = array_merge(
                array("ico"),
                explode(',', osc_allowed_extension())
            );
            foreach ($aExt as $ext) {
                if (isset($mimes[$ext])) {
                    $mime = $mimes[$ext];
                    if (is_array($mime)) {
                        foreach ($mime as $aux) {
                            if (!in_array($aux, $aMimesAllowed)) {
                                array_push($aMimesAllowed, $aux);
                            }
                        }
                    } else {
                        if (!in_array($mime, $aMimesAllowed)) {
                            array_push($aMimesAllowed, $mime);
                        }
                    }
                }
            }

            $bool_img = false;
            if ($aResources["error"] == UPLOAD_ERR_OK) {
                // check mime file
                $fileMime = $aResources['type'];
                if (stripos($fileMime, "image/")!==false) {
                    if (function_exists("getimagesize")) {
                        $info = getimagesize($aResources['tmp_name']);
                        if (isset($info['mime'])) {
                            $fileMime = $info['mime'];
                        } else {
                            $fileMime = '';
                        }
                    };
                };


                if (in_array($fileMime, $aMimesAllowed)) {
                    $bool_img = true;
                }
                if (!$bool_img && $success) {
                    $success = false;
                }
            }

            if (!$success) {
                osc_add_flash_error_message(_m("The file you tried to upload does not have a valid extension"), "admin");
            }
        }
        return $success;
    }

    protected static function mapArrayToPaths($array, $prefix = '')
    {
        $str            = '';
        $fresh_prefix   = $prefix;

        foreach ($array as $key => $value) {
            $fresh_prefix .= "/{$key}";

            if (is_array($value)) {
                $str .= self::mapArrayToPaths($value, $fresh_prefix);
                $fresh_prefix = $prefix;
            } else {
                $str .= "{$prefix}/{$key} = {$value}\n";
            }
        }

        return $str;
    }

    protected static function mapPathsToArray($str)
    {
        $array = array();
        $lines = explode("\n", trim($str));

        if (!empty($lines[0])) {
            foreach ($lines as $line) {
                list($path, $value) = explode(' = ', $line);

                $steps = explode('/', $path);
                array_shift($steps);

                $insertion =& $array;

                foreach ($steps as $step) {
                    if (!isset($insertion[$step])) {
                        $insertion[$step] = array();
                    }
                    $insertion =& $insertion[$step];
                }
                $insertion = $value;
            }
        }
        return $array;
    }
}
