<?php

class Madhouse_ThemeKitchen_Services_AjaxSearchService
{
    public static function getFeed($format = "html")
    {
        // Define the call as an ajax call for debug.
        if (!defined('IS_AJAX')) {
            define('IS_AJAX', true);
        }

        header('Content-type: text/json; charset=utf-8');
        Params::setParam('sFeed', null);
        $data = array();
        $data['header']           = self::renderHtml(self::getPath("parts/search/header.php"));
        $data['results']          = self::renderHtml(self::getPath("parts/search/results.php"));
        $data["categories_links"] = self::renderHtml(self::getPath("parts/search/refine-category.php"));
        $data["url"]              = self::getUrl();
        $data["title"]            = osc_esc_html(meta_title());
        $data["alert"]            = self::getAlert();
        echo json_encode($data);
    }

    public static function renderHtml($file)
    {
        ob_start();
        eval('?>' . $file . ' <?php ');
        $content = trim(preg_replace("/[\t\n]+/i", "", ob_get_contents()));
        ob_end_clean();
        return $content;
    }

    public static function renderHeader($file)
    {
        ob_start();
        eval('?>' . $file . ' <?php ');
        $content = trim(preg_replace("/[\t\n]+/i", "", ob_get_contents()));
        ob_end_clean();
        return $content;
    }

    public static function getPath ($name) {
        if(file_exists(WebThemes::newInstance()->getCurrentThemePath() . "/" . $name)) {
            $file = file_get_contents(WebThemes::newInstance()->getCurrentThemePath() . "/" . $name);
        }

        return $file;
    }

    public static function getUrl()
    {
        $params = Params::getParamsAsArray();
        unset($params["sFeed"]);
        return osc_search_url($params);
    }

    public static function getAlert()
    {
        // json
        $json           = Search::newInstance()->toJson();
        $encoded_alert  = base64_encode(osc_encrypt_alert($json));

        // Create the HMAC signature and convert the resulting hex hash into base64
        $stringToSign     = osc_get_alert_public_key() . $encoded_alert;
        $signature        = hex2b64(hmacsha1(osc_get_alert_private_key(), $stringToSign));
        $server_signature = Session::newInstance()->_set('alert_signature', $signature);
        return $encoded_alert;
    }

    public static function searchFilters() {;
        View::newInstance()->_exportVariableToView("search_category", array(Params::getParam("sCategory")));
        osc_run_hook("search_form", osc_search_category_id());
    }
}
