<?php

class Madhouse_ThemeKitchen_Modules_SocialModule extends Madhouse_ThemeKitchen_ModuleBase
{
    public function getAssets()
    {
        return array(
            array(
                "s_section" => "",
                "s_field" => "s_image"
            ),
        );
    }

    public function getViewFile()
    {
        return Madhouse_ThemeKitchen_Package::getPath("views/admin/_tab-social.php");
    }

    public function getId()
    {
        return "social_networks";
    }

    public function getMeta()
    {
        $defaultImages = array();
        if (osc_is_ad_page()) {
            $defaultTitle = osc_item_title();
            $defaultDescription = meta_description();

            while (osc_has_item_resources()) {
                array_push($defaultImages, osc_resource_url());
            }

            osc_reset_resources();
        } else {
            $defaultTitle = meta_title();
            $defaultDescription = meta_description();
        }

        $includeCustomeMeta = !osc_is_search_page() && !osc_is_public_profile() && !osc_is_static_page() && !osc_is_ad_page();

        echo "<!-- Social start -->";

        foreach (mtk_field("$", "social_networks") as $index => $value) {
            $ext = "";

            if ($value["s_slug"] == "facebook") {
                $ext = "og";
            } elseif ($value["s_slug"] == "twitter") {
                $ext = "twitter";
            } elseif ($value["s_slug"] == "gplus") {
                $ext = "itemprop";
            }
            if ($ext != "") {
                printf("<!-- %s -->", $value["s_name"]);

                $aImages = $defaultImages;
                if (empty($aImages) && isset($value["s_image"]) && $value["s_image"] != "") {
                    array_push($aImages, osc_base_url().$value['s_iamge']);
                }

                $title = $defaultTitle;
                if ($includeCustomeMeta && mtk_field(array("social_networks", $index ), "s_title") != "") {
                    $title = mtk_field(array("social_networks", $index ), "s_title");
                }

                $description = $defaultDescription;
                if ($includeCustomeMeta && mtk_field(array("social_networks", $index ), "s_description") != "") {
                    $description = mtk_field(array("social_networks", $index ), "s_description");
                }

                if ($title != "") {
                    printf('<meta property="%s:title" content="%s" />', $ext, $title);
                }

                if ($description != "") {
                    printf('<meta property="%s:description" content="%s" />', $ext, $description);
                }

                if (count($aImages) > 0) {
                    foreach ($aImages as $key => $value) {
                        printf('<meta property="%s:image" content="%s" />', $ext, $value);
                    }
                }
            }

            $aImages = array();
        }

        echo "<!-- Social end -->";
    }
}
