<?php

class Madhouse_ThemeKitchen_Models_Settings
{
    public function getTableName()
    {
        return DB_TABLE_PREFIX . "t_preference";
    }

    public function getSection()
    {
        return "theme_" . Madhouse_ThemeKitchen_Package::getThemeSlug();
    }

    public function getName($module)
    {
        return "settings_" . $module->getId();
    }

    public function getConfiguration()
    {
        // Get preference @ database.
        $results = osc_get_preference(
            "configuration",
            $this->getSection()
        );

        // Return a proper object.
        return $this->buildObject($results);
    }

    public function findSettingsByModule($module)
    {
        // Get preference @ database.
        $results = osc_get_preference(
            "settings_" . $module->getId(),
            $this->getSection()
        );

        // Return a proper object.
        return $this->buildObject($results);
    }

    /**
     * Internal method to set settings directly.
     *
     * Use at your own peril.
     *
     * @param string    $key
     * @param Any       $value
     * @param string    $type
     */
    public function set($key, $value, $type = "STRING")
    {
        if (is_object($value) && method_exists($value, "toArray")) {
            // Convert to array and encode to Json.
            $value = json_encode($value->toArray());
        } elseif (is_array($value)) {
            // Serialize to Json.
            $value = json_encode($value);
        }

        // Set preference to database..
        osc_set_preference(
            $key,
            $value,
            $this->getSection(),
            $type
        );

        // Apply changes to the object.
        return osc_reset_preferences();
    }

    public function get($key)
    {
        // Get preference @ database.
        return osc_get_preference(
            $key,
            $this->getSection()
        );
    }

    /**
     * Set the module settings in table.
     *
     * @param  Madhouse_ThemeKitchen_ModuleBase $module
     * @param  Madhouse_ThemeKitchen_Settings2  $settings
     *
     * @return boolean
     */
    public function updateModule($module, $settings)
    {
        // Set preference @ database.
        $this->set(
            "settings_" . $module->getId(),
            $settings->toArray(),
            $this->getSection(),
            "STRING"
        );

        // Return a proper object.
        return $this->findSettingsByModule($module);
    }

    public function buildObject($results)
    {
        // Decode JSON and return.
        $data = json_decode($results, true);
        if (!$data) {
            $data = array();
        }
        return new Madhouse_ThemeKitchen_Settings2($data);
    }
}
