/**
 * CODEMIRRORS.
 * @var Array<id,Codemirror>
 */
var editors = {};

(function($) {

	function initCodeMirror(e)
	{
		var editor = CodeMirror.fromTextArea(
			e.get(0),
			{
				indentUnit: 4,
				lineNumbers: true,
				lineWrapping: true,
				matchBrackets: true,
				mode: e.data("mode")
			}
		);
		editor.setOption("theme", "pastel-on-dark");
		return editor;
	}

	function handleCodeMirror($editor)
	{
		var id = $editor.attr("id");

		// Create the editor if it does not exists.
		if(id && editors[id] === undefined) {
			editors[id] = initCodeMirror($editor);
		}

		// Refresh.
		if(editors[id]) {
			editors[id].refresh();
		}
	}

	$(document).ready(function() {

		/**
		 * CODEMIRRORS.
		 * - Enable/Refresh codemirrors on tab change / collapse open.
		 */

        handleCodeMirror($("#design-custom-css"));
        handleCodeMirror($("#backup-settings"));

		$(document).on('shown.bs.tab', '.nav.nav-tabs', function(event) {
			var target = $(event.target).attr("href"),
				$panel = $(target),
				$editor = $panel.find("[data-toggle='codemirror']");
			handleCodeMirror($editor);
		});
		$(document).on('shown.bs.collapse', '.collapse', function(event) {
			var $editor = $(event.target).find("[data-toggle='codemirror']");
			handleCodeMirror($editor);
		});

		$('[data-toggle="sheeper"]').on("sheeped.jq.sheeper", function(event, d) {
			var $sheep = $(event.target);
			handleCodeMirror($sheep.find("[data-toggle='codemirror']"));
		});

		/**
		 * BOOTSTRAP LOADING BUTTON.
		 * - Disables the submit button after the first click.
		 */
		$('[type="submit"]').on('click', function() {
    		$(this).button('loading');
    	});

    	/**
    	 * FIX FOR MODERN ADMIN THEME.
    	 * - @see ui-osc.js: selectUi()
    	 */
    	$(".select-box").each(function(i, e) {
    		var $e = $(e),
    			$select = $e.children("select");
    		$select.insertBefore($e);
    		$select.css({ opacity: "" });
    		$e.remove();
    	});

        /**
         * JQUERY-UI.
         */
        $("[data-toggle='sheeper'] .sheeps").sortable({
            placeholder: "ui-sortable-placeholder",
            handle: ".panel-heading",
            helper: function (event, element) {
                return element
                    .clone()
                    .find(':input')
                    .attr('name', function(i, currentName) {
                        var newName = 'sort_' + parseInt(Math.random() * 100000, 10).toString() + '_' + currentName;
                        return newName;
                    })
                    .end()
                ;
            },
            start: function (event, ui) {
                ui.placeholder.height(ui.item.height());
            },
            stop: function (event, ui) {
                var target = ui.item[0],
                    sheeper = $(this).closest("[data-toggle='sheeper']");

                sheeper.trigger("moved.jq.sheeper");
            }
        });

        /*
         * Bootstrap switch (toggle).
         */
        $("[data-toggle='toggle']").bootstrapSwitch();

        /*
         * Colorpicker.
         */
        $('.js-colorpicker').colorpicker({
            customClass: 'colorpicker-2x',
            sliders: {
                saturation: {
                    maxLeft: 150,
                    maxTop: 150
                },
                hue: {
                    maxTop: 150
                },
                alpha: {
                    maxTop: 150
                }
            }
        });

        // Re-enable click on input to show the colorpicker.
        $(".js-colorpicker").on("create", function (e) {
            var colorpicker = $(e.target).data("colorpicker");
            colorpicker.input.on("click.colorpicker", function (e) {
                colorpicker.show();
            });
        });

    	/**
    	 * SUBMIT.
    	 * - Submitting the form in PHP triggers a PHP warning 'max_input_vars'
    	 *   and is too dependant of server configuration.
    	 */
    	$("form.js-themekitchen-settings").submit(function(event){
    		// Preventing the form to submit.
    		// event.preventDefault();

    		var $this = $(this),
    			$inputs = $this.find("input,select,textarea"),
    			$hidden = $('<input type="hidden" name="_settings" />'),
    			jsonString;

            // Save all codemirrors to their textarea counterpart.
            $.each(editors, function (editorId, editor) {
                editor.save();
            });

            // Force each colorpicker to update their input.
            $('.js-colorpicker').each(function (i, e) {
                $(e).data("colorpicker").update();
            });

            // Serialize.
            jsonString = JSON.stringify($inputs.serializeJSON({checkboxUncheckedValue: "false", parseBooleans: true}));

    		$inputs.each(function(i, e) {
    			var $e = $(e);
    			if($e.attr("type") !== "file" && $e.attr("type") !== "hidden") {
    				$(e).attr("disabled", "disabled");
    			}
    		});

    		$hidden.val(jsonString);
    		$this.append($hidden);

    		//$this.submit(true);
    	});
	});
})(jQuery);
