<?php
    /**
     * Head location:   base.php
     * Header location: parts/header.php
     * Footer location: parts/footer.php
     */
?>
<?php osc_add_hook("content", function () {
    ?>

    <div class="section section-cover-img">
        <div class="container">
            <div class="row">
                <div class="col-sm-6 col-sm-offset-3">
                    <div class="card card-flat card-user">
                        <div class="card-block text-center">
                            <?php if (function_exists("mdh_avatar_normal_url")) :?>
                                <div class="m-b-lg">
                                    <img class="img-avatar width-md" src="<?php echo mdh_avatar_normal_url(osc_user_id()) ;?>" />
                                </div>
                            <?php endif; ?>
                            <h1 class="h2 card-title title-special user-name">
                                <?php echo mtk_title(); ?>
                            </h1>
                            <?php mcf_voting_user_result(); ?>
                            <ul class="list-unstyled text-muted text-sm m-b-lg">
                                <?php if (osc_user_website() != "") : ?>
                                    <li class="user-website m-b-sm">
                                        <a href="<?php echo osc_user_website(); ?>" rel="nofollow" target="_blank">
                                            <?php echo osc_user_website(); ?>
                                        </a>
                                    </li>
                                <?php endif; ?>
                            </ul>
                            <?php if (osc_plugin_is_enabled('madhouse_user_attributes/index.php')): ?>
                                    <div class="m-b-md">
                                        <?php osc_run_hook('mdh_user_attributes_show') ?>
                                    </div>
                                <?php endif ?>
                            <?php if (mtk_field("$.layout", "i_user_public_profile_contact_form")) : ?>
                                <button type="button" class="btn btn-primary btn-outline btn-block" data-toggle="modal" data-target="#modalContact">
                                    <?php _e('Contact', osc_current_web_theme()) ?>
                                </button>
                                <?php osc_current_web_theme_path('parts/item/contact-modal.php'); ?>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <?php if (osc_user_info() !== '') : ?>
    <div class="section">
        <div class="container">
            <div class="row">
                <div class="col-sm-10 col-sm-offset-1">
                    <div class="m-b-md">
                        <h2><?php printf(__("Description", osc_current_web_theme()), osc_user_name()); ?></h2>
                        <?php echo nl2br(osc_user_info()); ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <?php endif; ?>
    <?php
    $location = array();
    if (mcf_user_location() != "") {
        array_push($location, mcf_user_location());
    }
    if (mcf_user_address() != "") {
        array_push($location, mcf_user_address());
    }
    ?>
    <?php if (count($location) > 0) : ?>
        <div class="container-fluid">
            <h3 class="">
                <?php _e("Address", osc_current_web_theme())?>
                <span class="text-xs text-muted">
                    <?php echo implode(', ', $location); ?>
                </span>
            </h3>
        </div>
        <?php if (osc_plugin_is_enabled("google_maps/index.php")): ?>
            <div class="height-lg bg-ligth pos-relative b-b b-t b-2x" id="js-map">
                <script type="text/javascript">
                    var map = null;
                    var geocoder = null;

                    var myOptions = {
                        zoom: 13,
                        center: new google.maps.LatLng(37.4419, -122.1419),
                        mapTypeId: google.maps.MapTypeId.ROADMAP,
                        size: new google.maps.Size(480,240),
                        disableDefaultUI: true,
                        scrollwheel: false,
                        navigationControl: false,
                        mapTypeControl: false,
                        scaleControl: false,
                        draggable: false,
                        mapTypeId: google.maps.MapTypeId.ROADMAP
                    }

                    map = new google.maps.Map(document.getElementById("js-map"), myOptions);
                    geocoder = new google.maps.Geocoder();

                    function showAddress(address) {
                        if (geocoder) {
                            geocoder.geocode( { 'address': address}, function(results, status) {
                                if (status == google.maps.GeocoderStatus.OK) {
                                    map.setCenter(results[0].geometry.location);
                                    var marker = new google.maps.Marker({
                                        map: map,
                                        position: results[0].geometry.location
                                    });
                                    marker.setMap(map);
                                } else {
                                    $("#js-map").remove();
                                }
                            });
                        }
                    }
                    $(document).ready(function(){
                        showAddress('<?php echo osc_esc_js(implode(', ', $location)); ?>');
                    });
                </script>
            </div>
        <?php endif ?>
    <?php endif; ?>
    <div class="section section-astride">
        <div class="container">
            <div class="row">
                <div class="col-sm-10 col-sm-offset-1">
                    <div id="latest-listings">
                        <?php if (osc_count_items() > 0) : ?>
                            <div class="pull-right">
                                <ul class="nav nav-pills">
                                    <li class="<?php echo (Params::getParam("sShowAs") == "list")? "active": "" ?>">
                                        <a href="<?php echo osc_user_public_profile_url(); ?>?sShowAs=list#latest-listings" rel="nofollow">
                                            <i class="ion-navicon-round"></i>&nbsp;<span><?php _e('List', osc_current_web_theme()); ?></span>
                                        </a>
                                    </li>
                                    <li
                                        class="<?php echo (Params::getParam("sShowAs") == "gallery")? "active": "" ?>">
                                        <a href="<?php echo osc_user_public_profile_url(); ?>?sShowAs=gallery#latest-listings" rel="nofollow">
                                            <i class="ion-grid"></i>&nbsp;<span><?php _e('Grid', osc_current_web_theme()); ?></span>
                                        </a>
                                    </li>
                                </ul>
                            </div>
                        <?php endif; ?>
                        <div class="m-b-lg">
                            <h2><span class="text-white"><?php printf(__("Latest listings", osc_current_web_theme()), osc_user_name()) ?></span></h2>
                        </div>
                        <?php if (osc_count_items() == 0) : ?>
                                <span class="text-white"><?php printf(__("%s has not any listing yet.", osc_current_web_theme()), osc_user_name()) ?></span>
                        <?php else : ?>
                            <div class="row row-sm no-gutter-xs <?php echo (mtk_field("$.design", "i_masonry") && osc_search_show_as() !="list") ? "js-masonry" : ""?>">
                                <?php
                                View::newInstance()->_exportVariableToView("sShowAs", Params::getParam("sShowAs"));
                                if (Params::getParam("sShowAs") == "list") {
                                    View::newInstance()->_exportVariableToView("col", "col-xs-12");
                                } else {
                                    $class = 'col-xs-12 col-sm-6 col-md-4';
                                    $class .= (mtk_field("$.design", "i_masonry")) ? " grid-item" : "";
                                    View::newInstance()->_exportVariableToView("col", $class);
                                }
                                osc_current_web_theme_path('parts/loop/loop.php'); ?>
                            </div>
                            <?php if (Params::getParam('itemsPerPage') != 'all'): ?>
                            <div class="paginate">
                                <?php mcf_user_item_pagination(
                                    array(),
                                    Params::getParam('itemsPerPage')
                                ); ?>
                            </div>
                            <?php endif; ?>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <?php if (osc_plugin_is_enabled("madhouse_facebook/index.php")  && mtk_field("$.layout", "i_user_comments_facebook")) : ?>
        <div class="container">
            <div class="row">
                <div class="col-sm-10 col-sm-offset-1">
                    <div class="card">
                        <div class="card-block">
                            <?php osc_run_hook('mdh_facebook_comments'); ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    <?php endif; ?>
<?php }); ?>

<?php osc_current_web_theme_path("base-full.php"); ?>
