<?php
    /**
     * Head location:   base.php
     * Header location: parts/header.php
     * Footer location: parts/footer.php
     */

    osc_add_filter("mcf_oneaction_title", function ($text) {
        return mtk_title();
    });

    osc_add_filter("mcf_oneaction_smalltext", function ($text) {
        return __("Where have you been? We have been missing you, a lot!", osc_current_web_theme());
    });

?>

<?php if (Params::existParam("modal_form")) : ?>
    <?php Session::newInstance()->_dropMessage('pubMessages'); ?>
    <div class="modal-header">
        <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
        <h4 class="modal-title" id="modalLogin"><?php _e('Login', osc_current_web_theme()) ?></h4>
    </div>
    <div class="modal-body">
        <?php osc_current_web_theme_path('parts/user/login-form.php'); ?>
    </div>
    <div class="modal-footer">
        <div class="text-center">
            <a class="btn btn-primary btn-outline btn-block" href="<?php echo osc_register_account_url(); ?>">
                <?php _e("Register for a free account", osc_current_web_theme()); ?>
            </a>
        </div>
    </div>
    <script type="text/javascript">
        $(".js-validate").validate();
    </script>
<?php else : ?>
    <?php osc_add_hook("mcf_oneaction_body", function () {
    ?>
        <?php osc_current_web_theme_path('parts/user/login-form.php'); ?>
        <div class="text-center">
            <a class="" href="<?php echo osc_register_account_url(); ?>">
                <?php _e("Register for a free account", osc_current_web_theme()); ?>
            </a>
        </div>
    <?php }); ?>

    <?php osc_current_web_theme_path("base-oneaction.php"); ?>
<?php endif ?>
