<?php osc_add_hook("content", function () {
    ?>
    <?php $filtersLabel = array(
        'active'           => __('active', osc_current_web_theme()),
        'blocked'          => __('blocked', osc_current_web_theme()),
        'premium'          => __('premium', osc_current_web_theme()),
        'pending_validate' => __('pending validate', osc_current_web_theme()),
        'expired'          => __('expired', osc_current_web_theme())
    ); ?>
    <div class="section">
        <div class="container">
            <div class="card">
                <div class="card-header">
                    <div class="pull-left">
                    <h1 class="h5 l-h-input-sm m-b-0">
                        <?php if (__get('items_type') == ""): ?>
                            <?php echo mtk_title(); ?>
                        <?php else: ?>
                            <?php printf(__("Listings: %s", osc_current_web_theme()), $filtersLabel[__get('items_type')]);  ?>
                        <?php endif ?>
                    </h1>
                    </div>
                    <div class="pull-right">
                        <div class="dropdown">
                            <button class="btn btn-default btn-sm dropdown-toggle" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="true">
                                <?php _e("Filter", osc_current_web_theme()) ?>
                                <span class="caret"></span>
                            </button>
                            <ul class="dropdown dropdown-menu dropdown-menu-right" aria-labelledby="item-actions">
                                <li class="<?php echo (__get('items_type') == "")?'active':""; ?>">
                                    <a href="<?php echo osc_user_list_items_url('', '') ?>">
                                    <?php _e("Show all listings", osc_current_web_theme()) ?>
                                    </a>
                                </li>
                                <li class="<?php echo (__get('items_type') == "active")?'active':""; ?>">
                                    <a href="<?php echo osc_user_list_items_url('', 'active') ?>">
                                        <?php _e("Show active", osc_current_web_theme()) ?>
                                    </a>
                                </li>
                                <li class="<?php echo (__get('items_type') == "blocked")?'active':""; ?>">
                                    <a href="<?php echo osc_user_list_items_url('', 'blocked') ?>">
                                        <?php _e("Show blocked", osc_current_web_theme()) ?>
                                    </a>
                                </li>
                                <li class="<?php echo (__get('items_type') == "premium")?'active':""; ?>">
                                    <a href="<?php echo osc_user_list_items_url('', 'premium') ?>">
                                        <?php _e("Show premium", osc_current_web_theme()) ?>
                                    </a>
                                </li>
                                <li class="<?php echo (__get('items_type') == "pending_validate")?'active':""; ?>">
                                    <a href="<?php echo osc_user_list_items_url('', 'pending_validate') ?>">
                                        <?php _e("Show in moderation", osc_current_web_theme()) ?>
                                    </a>
                                </li>
                                <li class="<?php echo (__get('items_type') == "expired")?'active':""; ?>">
                                    <a href="<?php echo osc_user_list_items_url('', 'expired') ?>">
                                        <?php _e("Show expired", osc_current_web_theme()) ?>
                                    </a>
                                </li>
                            </ul>
                        </div>
                    </div>
                </div>
                <?php if (osc_count_items() > 0) : ?>
                    <div class="list-group">
                        <?php View::newInstance()->_exportVariableToView("col", "list-group-item"); ?>
                        <?php osc_current_web_theme_path('parts/loop/loop.php'); ?>
                    </div>
                <?php else : ?>
                    <h3>
                    </h3>
                    <div class="row hbox height-lg text-center">
                        <div class="col-middle col-xs-6 col-xs-offset-3">
                            <?php if (__get('items_type') == ""): ?>
                                <h2 class="h3"><?php _e("No listings have been added yet", osc_current_web_theme()); ?></h2>
                                <a class="btn btn-primary btn-block" href="<?php echo(osc_item_post_url()); ?>">
                                    <?php _e("Post a listing", osc_current_web_theme()) ?>
                                </a>
                            <?php else: ?>
                                <h2 class="h3">
                                    <?php printf(__("No %s listing", osc_current_web_theme()), strtolower($filtersLabel[__get('items_type')]));  ?>
                                </h2>
                            <?php endif; ?>
                        </div>
                    </div>
                <?php endif; ?>
                <?php osc_current_web_theme_path("parts/user/footer.php"); ?>
                <?php osc_current_web_theme_path('parts/item/delete-modal.php'); ?>
            </div>
            <div class="paginate"><?php mcf_user_item_pagination(array(), __get("items_type")); ?></div>
        </div>
    </div>
<?php }); ?>

<?php osc_current_web_theme_path("base-full.php"); ?>
