<?php
    /**
     * Head location:   base.php
     * Header location: parts/header.php
     * Footer location: parts/footer.php
     */
?>
<?php osc_add_hook("content", function () {
    ?>

    <div class="section">
        <div class="container">
            <div class="card">
                <h1 class="card-header h4"><?php echo mtk_title(); ?></h1>
                <?php if (osc_count_alerts() > 0) : ?>
                    <div class="list-group">
                        <?php
                        $i = 1;
                        while (osc_has_alerts()) : ?>
                            <?php
                            $search = osc_alert_search();
                            $search = json_decode($search);
                            $params = array();
                            View::newInstance()->_exportVariableToView('categories', array());
                            if (count($search->aCategories) > 0):
                                View::newInstance()->_exportVariableToView('categories', Category::newInstance()->listWhere(sprintf('a.pk_i_id IN (%s)', implode(',', $search->aCategories))));

                                if (osc_count_categories() > 0):
                                    $params['sCategory'] = $search->aCategories;
                                endif;
                            endif;
                            $filters = array();
                            if ($search->sPattern != "") {
                                array_push($filters, array(
                                        'label' => __("Pattern", osc_current_web_theme()),
                                        'value' => $search->sPattern
                                    )
                                );
                                $params['sPattern'] = $search->sPattern;
                            }

                            if (count($search->cities) > 0) {
                                $search->cities = mcf_alert_location($search->cities, City::newInstance(), 'city');
                                if (count($search->cities) > 0) {
                                    array_push($filters, array(
                                            'label' => __("City", osc_current_web_theme()),
                                            'value' => implode(',', $search->cities)
                                        )
                                    );
                                    $params['sCity'] = implode(',', $search->cities);
                                }
                            }

                            if (count($search->regions) > 0) {

                                $search->regions = mcf_alert_location($search->regions, Region::newInstance(), 'region');
                                if (count($search->regions) > 0) {
                                    array_push($filters, array(
                                            'label' => __("Region", osc_current_web_theme()),
                                            'value' => implode(',', $search->regions)
                                        )
                                    );
                                    $params['sRegion'] = implode(',', $search->regions);
                                }
                            }

                            if (count($search->countries) > 0) {
                                $search->countries = mcf_alert_location($search->countries, Country::newInstance(), 'country');
                                if (count($search->countries) > 0) {
                                    array_push($filters, array(
                                            'label' => __("Country", osc_current_web_theme()),
                                            'value' => implode(',', $search->countries)
                                        )
                                    );
                                    $params['sCountry'] = implode(',', $search->countries);
                                }
                            }

                            if ($search->price_min != 0) {
                                array_push($filters, array(
                                        'label' => __("Price min", osc_current_web_theme()),
                                        'value' => $search->price_min
                                    )
                                );
                                $params['sPriceMin'] = $search->price_min;
                            }

                            if ($search->price_max != 0) {
                                array_push($filters, array(
                                        'label' => __("Price max", osc_current_web_theme()),
                                        'value' => $search->price_max
                                    )
                                );
                                $params['sPriceMax'] = $search->price_max;
                            }

                            if (isset($search->withPicture)) {
                                array_push($filters, array(
                                        'label' => __("With picture", osc_current_web_theme()),
                                        'value' => '<i class="ion-checkmark-round text-success"></i>'
                                    )
                                );
                                $params['bPic'] = 1;
                            }
                            $value = "";
                            if ($search->order_column == 'i_price' && $search->order_direction == 'desc') {
                                $value = __("Higher price first", osc_current_web_theme());
                            } elseif ($search->order_column == 'i_price' && $search->order_direction == 'asc') {
                                $value = __("Lower price first", osc_current_web_theme());
                            } elseif ($search->order_column == 'dt_pub_date') {
                                $value = __("Newly listed", osc_current_web_theme());
                            }

                            array_push($filters, array(
                                    'label' => __("Order", osc_current_web_theme()),
                                    'value' => $value
                                )
                            );
                            $params['sOrder'] = $search->order_column;
                            $params['iOrderType'] = $search->order_direction;

                            if (count($search->no_catched_conditions) > 0) {
                                $noCatchedConditions = 0;
                                foreach ($search->no_catched_conditions as $condition) {
                                    if (strpos($condition, 'mkt_user.b_company = 1') !== false) {
                                        array_push($filters, array(
                                                'label' => __("Type", osc_current_web_theme()),
                                                'value' => __("Profesional", osc_current_web_theme())
                                            )
                                        );
                                        $params['type'] = 'profesional';
                                    } elseif (strpos($condition, 'coalesce(mkt_user.b_company, 0) <> 1') !== false) {
                                        array_push($filters, array(
                                                'label' => __("Type", osc_current_web_theme()),
                                                'value' => __("Personal", osc_current_web_theme())
                                            )
                                        );
                                        $params['type'] = 'personal';
                                    } else {
                                        $noCatchedConditions++;
                                    }
                                }

                                if ($noCatchedConditions > 0) {
                                    array_push($filters, array(
                                            'label' => __("Unkown filters", osc_current_web_theme()),
                                            'value' => $noCatchedConditions
                                        )
                                    );
                                }
                            }

                            ?>
                            <div class="list-group-item">
                                <div class="p-md">
                                    <div class="clearfix">
                                        <div class="pull-left">
                                            <h2 class="h3 row-space-0 l-h-input"><?php _e('Alert', osc_current_web_theme()); ?> <?php echo $i; ?></h2>
                                        </div>
                                        <div class="pull-right">
                                            <ul class="list-inline">
                                                <li>
                                                    <a class="btn btn-primary" href="<?php echo osc_search_url($params); ?>"><?php _e("See search", osc_current_web_theme()); ?></a>
                                                </li>
                                                <li>
                                                    <a class="btn btn-danger" onclick="javascript:return confirm('<?php echo osc_esc_js(__('This action can\'t be undone. Are you sure you want to continue?', osc_current_web_theme())); ?>');" href="<?php echo osc_user_unsubscribe_alert_url(); ?>"><i class="ion-trash-a"></i></a>
                                                </li>
                                            </ul>
                                        </div>
                                    </div>
                                    <div class="row m-b-sm text-muted">
                                        <?php if (osc_count_categories() > 0): ?>
                                            <div class="col-xs-12 p-y-sm">
                                                <div class="b-b clearfix">
                                                    <div class="m-b-sm">
                                                        <span class="font-bold"><?php echo (osc_count_categories() == 1) ? __("Category", osc_current_web_theme()) : __("Categories", osc_current_web_theme()) ?></span>
                                                        </span>
                                                    </div>
                                                    <span class="text-muted">
                                                        <?php echo implode(', ', array_map(function($v) {
                                                            return $v['s_name'];
                                                        }, __get("categories"))); ?>
                                                    </span>
                                                </div>
                                            </div>
                                        <?php endif; ?>
                                        <?php foreach ($filters as $filter): ?>
                                            <div class="col-xs-12 col-md-3 p-y-sm <?php echo (isset($filter['class'])) ? $filter['class'] : '' ?>">
                                                <div class="b-b clearfix">
                                                    <span class="font-bold pull-left"><?php echo $filter['label'] ?></span>
                                                    <span class="pull-right <?php echo (isset($filter['class'])) ? $filter['class'] : 'text-muted' ?>">
                                                        <?php echo $filter['value'] ?>
                                                    </span>
                                                </div>
                                            </div>
                                        <?php endforeach; ?>
                                    </div>
                                    <h3 class="h4 m-b"><?php _e("Listings", osc_current_web_theme()); ?></h3>
                                    <?php if (osc_count_items() > 0) : ?>
                                        <div class="row">
                                            <?php while (osc_has_items()) : ?>
                                                <div class="col-md-6">
                                                    <div class="b-b p-y-sm clearfix">
                                                    <span class="pull-left text-ellipsis"><span class="label label-primary"><?php echo osc_item_category(); ?></span>&nbsp;<a  target="_blank" href="<?php echo osc_item_url() ?>"><?php echo osc_item_title(); ?></a></span>
                                                    <span class="pull-right"><?php echo osc_item_formated_price() ?></span>
                                                    </div>
                                                </div>
                                            <?php endwhile; ?>
                                        </div>
                                    <?php else : ?>
                                        <span class="   text-muted"><?php _e("No results for this alert, yet", osc_current_web_theme()); ?></span>
                                    <?php endif; ?>
                                </div>
                            </div>
                        <?php
                        $i++;
                        endwhile; ?>
                    </div>
                <?php else : ?>
                    <div class="row hbox height-lg text-center">
                        <div class="col-middle col-xs-6 col-sm-offset-3">
                            <h2 class="h3"><?php _e("You do not have any alerts yet", osc_current_web_theme()); ?></h2>
                            <span class="text-muted"><?php _e("Try to add one!", osc_current_web_theme()); ?></span>
                        </div>
                    </div>
                <?php endif; ?>
                <?php osc_current_web_theme_path("parts/user/footer.php"); ?>
            </div>
        </div>
    </div>
<?php }); ?>

<?php osc_current_web_theme_path("base-full.php"); ?>
