<div class="container">
    <div class=" m-y-lg">
        <div class="card">
        <div class="card-header">
            <ul class="nav nav-pills nav-link nav-sm hover-animated pull-left">
                <li>
                    <div class="dropdown">
                        <button class="btn btn-default btn-sm dropdown-toggle" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="true">
                            <?php if (Params::getParam("label")): ?>
                                <?php printf("%s", mdh_current_label()->getTitle()) ?>
                            <?php else: ?>
                                <?php _e("Label", osc_current_web_theme()) ?>
                            <?php endif ?>
                            <span class="caret"></span>
                        </button>
                        <ul class="dropdown-menu" aria-labelledby="thread-actions">
                            <?php while (mdh_has_thread_labels()) :?>
                                <?php if (mdh_current_label()->getName() != mdh_thread_label_name()): ?>
                                    <li class="">
                                        <a href="<?php echo mdh_messenger_inbox_url(array("label" => mdh_thread_label_name())); ?>">
                                            <?php echo mdh_thread_label_title(); ?>
                                        </a>
                                    </li>
                                <?php endif ?>
                            <?php endwhile; ?>
                            <?php
                            if (Params::getParam("filter") === "unread") :
                                $icon = '<i class="ion-checkmark-round"></i>';
                                $url = mdh_messenger_inbox_url(array("label" => Params::getParam("label"), "filter" => ""));
                            else :
                                    $icon = "";
                                    $url = mdh_messenger_inbox_url(array("label" => Params::getParam("label"), "filter" => "unread"));
                            endif;
                            ?>
                            <li class="visible-xs-block <?php echo (Params::getParam("filter") === "unread") ? "font-bold" : ""; ?>">
                                <a href="<?php echo $url ?>">
                                    <?php echo $icon; ?>
                                    <?php _e("Unread", osc_current_web_theme()); ?>
                                </a>
                            </li>
                            <li class="visible-xs-block divider"></li>
                            <li class="visible-xs-block">
                                <a href="<?php echo mdh_messenger_thread_mark_all_read_url(); ?>">
                                    <?php _e("Mark all as read", osc_current_web_theme()); ?>
                                </a>
                            </li>
                        </ul>
                    </div>
                </li>
                <?php
                if (Params::getParam("filter") === "unread") :
                    $icon = '<i class="ion-checkmark-round"></i>';
                    $url = mdh_messenger_inbox_url(array("label" => Params::getParam("label"), "filter" => ""));
                else :
                        $icon = "";
                        $url = mdh_messenger_inbox_url(array("label" => Params::getParam("label"), "filter" => "unread"));
                endif;
                ?>
                <li class="hidden-xs <?php echo (Params::getParam("filter") === "unread") ? "active" : ""; ?>">
                    <a href="<?php echo $url ?>">
                        <?php echo $icon; ?>
                        <?php _e("Unread", osc_current_web_theme()); ?>
                    </a>
                </li>
                <li class="hidden-xs">
                    <a href="<?php echo mdh_messenger_thread_mark_all_read_url(); ?>">
                        <?php _e("Mark all as read", osc_current_web_theme()); ?>
                    </a>
                </li>
            </ul>
            <div class="pull-right">
                <?php
                    $params = array(
                        "label" => Params::getParam("label")
                    );
                ?>
                <div class="dropdown">
                    <button class="btn btn-default btn-sm dropdown-toggle" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="true">
                        <?php if (Params::getParam('item')): ?>
                            <?php printf(__("Listing: %s", osc_current_web_theme()), mdh_current_item()->getTitle()) ?>
                        <?php else: ?>
                            <?php _e("Filter", osc_current_web_theme()) ?>
                        <?php endif ?>
                        <span class="caret"></span>
                    </button>
                    <?php if (count(__get('items')) > 0): ?>
                        <ul class="dropdown-menu dropdown-menu-right" aria-labelledby="thread-actions">
                            <?php if (Params::getParam('item')): ?>
                                <li>
                                    <a href="<?php echo mdh_messenger_inbox_url($params); ?>">
                                        <?php _e("Remove filter", osc_current_web_theme()) ?>
                                    </a>
                                </li>
                            <?php endif ?>
                            <?php while (osc_has_items()): ?>
                                <?php if (Params::getParam('item') == "" || mdh_current_item()->getId() != osc_item_id()): ?>
                                    <li>
                                        <a href="<?php echo mdh_messenger_inbox_url(array_merge($params, array("item" => osc_item_id()))); ?>">
                                            <?php printf("Listing: %s", osc_item_title()) ?>
                                        </a>
                                    </li>
                                <?php endif ?>
                            <?php endwhile; ?>
                        </ul>
                    <?php endif ?>
                </div>
            </div>
        </div>
        <div class="">
            <div class="message-wrapper">
                <?php if (mdh_count_threads()) : ?>
                    <ul class="list-unstyled threads m-b-0">
                        <?php while (mdh_has_threads()) : ?>
                            <li class="panel-body thread content <?php echo (mdh_thread_has_unread()) ? "thread-unread": ""; ?>">
                                <div class="row pos-relative row-xs">
                                    <div class="col-sm-4 col-md-3 thread-author">
                                        <div class="row row-table row-sm">
                                            <?php if (osc_plugin_is_enabled("madhouse_avatar/index.php")) : ?>
                                                <div class="thread-avatar col-md-3 pull-left">
                                                  <a href="<?php echo mdh_thread_url(); ?>">
                                                    <img
                                                        alt="<?php echo osc_user_name(); ?>"
                                                        class="img-avatar img-avatar-sm width-xs"
                                                        src="<?php echo mdh_avatar_thumbnail_url(mdh_thread()->getOther()->getId()) ?>"
                                                        title="<?php echo osc_user_name(); ?>">
                                                    </a>
                                                </div>
                                            <?php endif ?>
                                            <div class="col-sm-7">
                                                <a class="link-reset" href="<?php echo mdh_thread_url(); ?>">
                                                    <div class="thread-title thread-name-container text-ellipsis">
                                                        <?php if(mdh_thread()->isBlocked()): ?>
                                                            <i class="ion-minus-circled text-danger"></i>
                                                        <?php endif ?>
                                                        <?php if (mdh_thread_has_unread()) : ?>
                                                            <strong class="text-ellipsis">
                                                                <?php
                                                                    printf(
                                                                        "%s (%d)",
                                                                        (mdh_thread_title()) ? mdh_thread_title() : mdh_thread()->getOther()->getName(),
                                                                        mdh_thread_count_unread()
                                                                    );
                                                                ?>
                                                            </strong>
                                                        <?php else : ?>
                                                            <?php echo mdh_thread()->getOther()->getName(); ?>
                                                        <?php endif; ?>
                                                    </div>
                                                    <div class="thread-date">
                                                        <span>
                                                            <?php echo mdh_thread_formatted_last_activity(); ?>
                                                        </span>
                                                    </div>
                                                </a>
                                            </div>
                                        </div>
                                    </div>
                                    <a href="<?php echo mdh_thread_url(); ?>" class="thread-link text-muted">
                                        <div class="col-xs-12 col-sm-4 col-md-5 thread-body">
                                            <div class="thread-subject ">
                                                <span class="text-ellipsis">
                                                    <?php echo mdh_thread_excerpt(); ?>
                                                </span>
                                            </div>
                                            <div class="text-muted visible-lg-block">
                                                <?php if (mdh_thread_had_item()):?>
                                                    <?php _e("Deleted listing", osc_current_web_theme()); ?>
                                                <?php elseif (mdh_thread_has_item() && osc_item_is_expired()): ?>
                                                    <?php _e("Expired listing", osc_current_web_theme()); ?>
                                                <?php elseif (mdh_thread_has_item() && (osc_item_is_spam() || !osc_item_is_enabled())): ?>
                                                    <?php _e("Spam or blocked listing", osc_current_web_theme()); ?>
                                                <?php elseif (mdh_thread_has_item() && !osc_item_is_active()): ?>
                                                    <?php _e("Deactivated listing", osc_current_web_theme()); ?>
                                                <?php elseif (mdh_thread_has_item()): ?>
                                                        <?php if(osc_item_city() != ""): ?>
                                                            <?php printf("%s - %s", osc_item_title(), osc_item_city()); ?>
                                                        <?php else: ?>
                                                            <?php echo osc_item_title(); ?>
                                                        <?php endif; ?>
                                                <?php else: ?>
                                                    <?php _e("No item linked to this thread", osc_current_web_theme()); ?>
                                                <?php endif; ?>
                                            </div>
                                        </div>
                                    </a>
                                    <div class="col-md-2 thread-label hidden-xs text-right">
                                        <?php if (mdh_thread_has_item()) : ?>
                                            <div>
                                                <span class="thread-price">
                                                    <?php echo osc_item_formated_price(); ?>
                                                </span>
                                            </div>
                                        <?php endif; ?>
                                        <?php if (mdh_thread_has_status()) : ?>
                                            <div>
                                                <span class="status status-<?php echo mdh_thread_status_name(); ?>">
                                                    <?php echo mdh_thread_status_title(); ?>
                                                </span>
                                            </div>
                                        <?php endif; ?>
                                    </div>
                                    <div class="col-md-2 thread-actions hidden-xs hidden-sm text-right">
                                        <div class="dropdown">
                                            <button class="btn btn-default btn-sm dropdown-toggle" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="true">
                                                <?php _e("More", osc_current_web_theme()) ?>
                                                <span class="caret"></span>
                                            </button>
                                            <ul class="dropdown-menu" aria-labelledby="thread-actions">
                                                <?php if (mdh_thread_has_item()): ?>
                                                    <li>
                                                        <a href="<?php echo mdh_thread()->getItem()->getUrl(); ?>">
                                                            <?php _e("See listing", osc_current_web_theme()); ?>
                                                        </a>
                                                    </li>
                                                <?php endif ?>
                                                <?php if (mdh_messenger_is_inbox_page()) : ?>
                                                    <li>
                                                        <a href="<?php echo mdh_messenger_thread_archive_url(mdh_thread_id()); ?>">
                                                            <?php _e("Archive", osc_current_web_theme()); ?>

                                                        </a>
                                                    </li>
                                                <?php elseif (mdh_messenger_is_archive_page()) : ?>
                                                    <li>
                                                        <a href="<?php echo mdh_messenger_thread_unarchive_url(mdh_thread_id()); ?>">
                                                            <?php _e("Unarchive", osc_current_web_theme()); ?>

                                                        </a>
                                                    </li>
                                                <?php endif; ?>
                                                <?php if(mdh_messenger_is_trash_page()): ?>
                                                    <li>
                                                        <a href="<?php echo mdh_messenger_thread_restore_url(mdh_thread_id()); ?>">
                                                            <?php _e("Restore", osc_current_web_theme()); ?>
                                                        </a>
                                                    </li>
                                                <?php else: ?>
                                                    <li>
                                                        <a href="<?php echo mdh_messenger_thread_delete_url(mdh_thread_id()); ?>">
                                                            <?php _e("Delete", osc_current_web_theme()); ?>
                                                        </a>
                                                    </li>
                                                <?php endif;?>
                                                <?php while (mdh_has_thread_labels()) : ?>
                                                    <?php if (!mdh_thread_label_is_system()) : ?>
                                                        <li>
                                                            <?php if (!mdh_thread_in_label(mdh_thread_label())) : ?>
                                                                <a href="<?php echo mdh_messenger_thread_label_add_url(mdh_thread_id(), mdh_thread_label_id()); ?>">
                                                                    <?php printf(__("Mark as %s", osc_current_web_theme()), mdh_thread_label_title()); ?>
                                                                </a>
                                                            <?php else : ?>
                                                                <a href="<?php echo mdh_messenger_thread_label_remove_url(mdh_thread_id(), mdh_thread_label_id()); ?>">
                                                                    <?php printf(__("Unmark as %s", osc_current_web_theme()), mdh_thread_label_title()); ?>
                                                                </a>
                                                            <?php endif; ?>
                                                        </li>
                                                    <?php endif; ?>
                                                <?php endwhile; ?>
                                                    <?php if (osc_get_preference("enable_mark_as_unread", "plugin_madhouse_messenger") &&
                                                        !mdh_thread()->getLastMessage()->isFromViewer() &&
                                                        !mdh_thread()->hasUnreadMessages()
                                                    ) : ?>
                                                        <li>
                                                            <a href="<?php echo mdh_messenger_thread_mark_unread_url(mdh_thread_id()); ?>">
                                                                <?php _e("Mark as unread", osc_current_web_theme()); ?>
                                                            </a>
                                                        </li>
                                                    <?php endif; ?>
                                                    <?php if (mdh_thread_can_block()) : ?>
                                                        <?php if(!mdh_thread()->isBlocked()): ?>
                                                            <li>
                                                                <a href="<?php echo mdh_messenger_block_user_url(mdh_thread()->getId()); ?>">
                                                                    <?php _e("Block", osc_current_web_theme()); ?>
                                                                </a>
                                                            </li>
                                                        <?php else: ?>
                                                            <li>
                                                                <a href="<?php echo mdh_messenger_unblock_user_url(mdh_thread()->getId()); ?>">
                                                                    <?php _e("Unblock", osc_current_web_theme()); ?>
                                                                </a>
                                                            </li>
                                                        <?php endif; ?>
                                                    <?php endif; ?>
                                            </ul>
                                        </div>
                                    </div>
                                </div>
                            </li>
                        <?php endwhile; ?>
                    </ul>
                <?php else : ?>
                    <div class="row hbox height-xl text-center">
                        <div class="col-middle col-xs-8 col-xs-offset-2">
                            <h2 class="h3">
                                <?php if (Params::getParam("filter") == "unread") : ?>
                                    <?php if (Params::getParam("item") != "") : ?>
                                        <?php printf(__("No unread messages for listing '%s' in %s, yet.", osc_current_web_theme()), mdh_current_item()->getTitle(), strtolower(mdh_current_label()->getName())); ?>
                                    <?php else : ?>
                                        <?php printf(__("No unread messages in %s, yet.", osc_current_web_theme()), strtolower(mdh_current_label()->getName())); ?>
                                    <?php endif; ?>
                                <?php else : ?>
                                    <?php if (Params::getParam("item") != "") : ?>
                                        <?php printf(__("No messages for listing '%s' in %s, yet.", osc_current_web_theme()), mdh_current_item()->getTitle(), strtolower(mdh_current_label()->getName())); ?>
                                    <?php else : ?>
                                        <?php printf(__("No messages in %s, yet.", osc_current_web_theme()), strtolower(mdh_current_label()->getName())); ?>
                                    <?php endif; ?>
                                <?php endif; ?>
                            </h2>
                            <span class="text-muted">
                                <?php _e("Try to contact somebody!", osc_current_web_theme()); ?>
                            </span>
                        </div>
                    </div>
                <?php endif; ?>
            </div>
            </div>
        </div>
        <?php

            $params = array(
            'total'              => (int) ceil(mdh_count_threads() / Params::getParam("n")),
            'selected'           => (int) Params::getParam("p") - 1,
            'class_prev'         => 'prev',
            'class_next'         => 'next',
            'class_selected'     => 'active',
            'url'                => mdh_messenger_inbox_url(
                array(
                    "label" => Params::getParam("label"),
                    "item" => Params::getParam("item"),
                    "filter" => Params::getParam("filter")
                ),
                '{PAGE}'
            )
        );
        $pagination = new ThemePagination($params);
        ?>
        <div class="pull-right">
            <?php echo $pagination->doPagination(); ?>
        </div>
        <div class="pull-right m-r-sm">
            <div class="showing-results space-out-l-sm text-muted">
                <?php echo mdh_pagination_from(Params::getParam("p"), Params::getParam("n")); ?>
                &nbsp;&ndash;&nbsp;
                <?php echo mdh_pagination_to(Params::getParam("p"), Params::getParam("n"), mdh_count_threads()); ?>
                &nbsp;<?php _e("on", osc_current_web_theme()); ?>&nbsp;
                <?php echo mdh_count_threads(); ?>
            </div>
        </div>
    </div>
</div>
    <?php osc_current_web_theme_path('parts/footer.php') ; ?>
</body>