<?php
    $menu = array();

if (mtk_field("$.layout", "i_dashboard_activation") == 0) {
    array_push(
        $menu,
        array(
        'label' => __("Dashboard", osc_current_web_theme()),
        'url' => osc_user_dashboard_url(),
        'class' => 'opt_dashboard',
        'active' => (osc_is_user_dashboard())? "active" :""
        )
    );
}

    array_push(
        $menu,
        array(
        'label' => __("Profile", osc_current_web_theme()),
        'url' => osc_user_profile_url(),
        'class' => 'opt_account',
        'active' => (osc_is_user_profile() || osc_is_change_email_page() || osc_is_change_password_page() || osc_is_current_page("user", "change_username"))? "active" :""
        ),
        array(
        'label' => __("Listings", osc_current_web_theme()),
        'url' => osc_user_list_items_url(),
        'class' => 'opt_items',
        'active' => (osc_is_list_items())? "active" :""
        ),
        array(
        'label' => __("Alerts", osc_current_web_theme()),
        'url' => osc_user_alerts_url(),
        'class' => 'opt_alerts',
        'active' => (osc_is_list_alerts())? "active" :""
        )
    );
?>
<div class="navbar navbar-primary lt user-navbar r-0">
    <div class="container">
        <div class="navbar-header visible-xs-block">
            <div class="navbar-brand visible-xs-block text-ellipsis">
                <span class="d-ib font-bold"><?php echo strlen(osc_logged_user_name()) > 15 ? substr(osc_logged_user_name(), 0, 15)."..." : osc_logged_user_name(); ?></span>
            </div>
            <button type="button" class="navbar-toggle collapsed" data-toggle="collapse" data-target=".user-menu">
                <span class="icon"></span>
                <span class="sr-only">
                    <?php _e("Toggle navigation", osc_current_web_theme()); ?>
                </span>
            </button>
        </div>
        <div class="user-menu collapse navbar-collapse user-menu">
            <ul class="nav navbar-nav hover-animated">
                <?php foreach ($menu as $key => $value) : ?>
                    <li class="<?php echo $value["class"] . " " . $value["active"]; ?>">
                        <a href="<?php echo $value["url"]; ?>">
                            <?php echo $value["label"]; ?>
                        </a>
                    </li>
                <?php endforeach; ?>
                <?php osc_run_hook("user_menu"); ?>
                <?php
                    $opt_logout = end($menu);
                ?>
                <li class="opt_logout">
                    <a href="<?php echo osc_user_logout_url(); ?>" >
                        <?php _e('Logout', osc_current_web_theme()); ?>
                    </a>
                </li>
            </ul>
        </div>
    </div>
</div>