<?php
    $count = 0;
?>
<?php View::newInstance()->_exportVariableToView(
    "countries",
    CountryStats::newInstance()->listCountries(">", "items DESC")
); ?>
<div class="tab-container">
    <ul id="js-popular-tabs" class="nav nav-tabs" role="tablist">
        <li class="active" role="presentation">
            <a href="#popular-categories" class="text-center" data-toggle="tab">
                <i class="ion-ios-search-strong"></i>&nbsp;<?php _e("Categories", osc_current_web_theme()) ?>
            </a>
        </li>
        <?php if (count("countries") > 1) : ?>
            <li role="presentation">
                <a href="#popular-countries" data-toggle="tab">
                    <i class="ion-earth"></i>&nbsp;<?php _e("Countries", osc_current_web_theme()) ?>
                </a>
            </li>
        <?php endif ?>
        <li role="presentation">
            <a href="#popular-regions" data-toggle="tab">
                <i class="ion-map"></i>&nbsp;<?php _e("Regions", osc_current_web_theme()) ?>
            </a>
        </li>
        <li role="presentation">
            <a href="#popular-cities" data-toggle="tab">
                <i class="ion-location"></i>&nbsp;<?php _e("Cities", osc_current_web_theme()) ?>
            </a>
        </li>
    </ul>
    <div class="tab-content">
        <div id="popular-categories" class="tab-pane active popular-tabs-categories" role="tabpanel">
            <?php osc_current_web_theme_path('parts/search/popular-categories.php'); ?>
        </div>
        <?php if (count("countries") > 1) : ?>
            <div id="popular-countries" class="tab-pane popular-tabs-countries" role="tabpanel">
                <div class="row text-center p-t-sm">
                    <?php
                        $count = 0;
                    ?>
                    <?php View::newInstance()->_exportVariableToView(
                        "countries",
                        CountryStats::newInstance()->listCountries(">", "items DESC")
                    ); ?>
                    <?php while (osc_has_countries()) : ?>
                        <div class="col-sm-3 m-b-sm">
                            <a class="font-secondary" href="<?php echo osc_search_url(array("sCountry" => osc_country_name())) ?>">
                                <?php echo osc_country_name() ?>&nbsp;<span class="popular-tabs-items">(<?php echo osc_country_items()?>)</span>
                            </a>
                        </div>
                        <?php
                        if ($count >= 7) {
                            break;
                        }
                            $count ++;
                        ?>
                    <?php endwhile?>
                </div>
            </div>
        <?php endif ?>
        <div id="popular-regions" class="tab-pane popular-tabs-regions" role="tabpanel">
            <div class="row text-center p-t-sm">
                <?php
                    $count = 0;
                    View::newInstance()->_exportVariableToView(
                        "regions",
                        RegionStats::newInstance()->listRegions("%%%%", ">", "items DESC")
                    ); ?>
                <?php while (osc_has_regions()) : ?>
                    <div class="col-sm-3 m-b-sm">
                        <a class="font-secondary" href="<?php echo osc_search_url(array("sRegion" => osc_region_name())) ?>">
                            <?php echo osc_region_name() ?>&nbsp;<span class="popular-tabs-items">(<?php echo osc_region_items()?>)</span>
                        </a>
                    </div>
                    <?php
                    if ($count >= 7) {
                        break;
                    }
                        $count ++;
                    ?>
                <?php endwhile?>
            </div>
        </div>
        <div id="popular-cities" class="tab-pane popular-tabs-cities" role="tabpanel">
            <div class="row text-center p-t-sm">
                <?php
                    $count = 0;
                    View::newInstance()->_exportVariableToView(
                        "cities",
                        CityStats::newInstance()->listCities(null, ">", "items DESC")
                    ); ?>
                <?php while (osc_has_cities()) : ?>
                    <div class="col-sm-3 m-b-sm">
                        <a class="font-secondary" href="<?php echo osc_search_url(array("sCity" => osc_city_name())) ?>">
                            <?php echo osc_city_name() ?>&nbsp;<span class="popular-tabs-items">(<?php echo osc_city_items()?>)</span>
                        </a>
                    </div>
                    <?php
                    if ($count >= 7) {
                        break;
                    }
                        $count ++;
                    ?>
                <?php endwhile?>
            </div>
        </div>
    </div>
</div>