<?php if (osc_item_is_premium()) : ?>
    <div class="overlay overlay-bottom-0 overlay-right-0 overlay-premium">
        <a
            href=""
            data-toggle="tooltip"
            data-placement="left"
            data-container="body"
            class="link-default"
            title="<?php _e("Premium", osc_current_web_theme()) ?>">
            <i class="ion-android-star"></i>
        </a>
    </div>
<?php endif; ?>
<?php if (osc_plugin_is_enabled("watchlist/index.php")) : ?>
    <div class="overlay overlay-top-0 overlay-right-0 overlay-watchlist">
        <?php $isInWatchlist = mcf_is_in_watchlist() ?>
        <a
            href="<?php echo (osc_is_web_user_logged_in()) ? "javascript://" : osc_user_login_url() ?>"
            data-toggle="tooltip"
            data-placement="left"
            data-container="body"
            class="p-sm d-b l-h-1 text-md <?php echo (osc_is_web_user_logged_in() && !$isInWatchlist) ? "js-watchlist" : "" ?>"
            id="<?php echo osc_item_id() ?>"
            data-url="<?php echo osc_ajax_plugin_url('watchlist/ajax_watchlist.php') ?>"
            title="
                <?php if (!osc_is_web_user_logged_in()) {
                    _e("Log in to add to watchlist", osc_current_web_theme());
                } elseif ($isInWatchlist){
                    _e("Already in watchlist", osc_current_web_theme());
                } else {
                    _e("Add to watchlist", osc_current_web_theme());
                } ?>
            ">
            <i class="ion-ios-heart<?php echo ($isInWatchlist) ? "" : "-outline" ?>"></i>
        </a>
    </div>
<?php endif; ?>
<?php if (osc_price_enabled_at_items()  && osc_item_price() != "") : ?>
    <div class="overlay overlay-top overlay-left-0 overlay-price">
        <span class="bg-dark text-inverse p-sm d-b font-secondary loop-item-price">
            <?php echo osc_format_price(osc_item_price()); ?>
        </span>
    </div>
<?php endif; ?>
<?php if (mcf_voting_can_vote()) : ?>
    <div class="overlay text-md loop-voting-result overlay-loop-voting-result">
        <span class="">
            <?php mcf_voting_result() ?>
        </span>
    </div>
<?php endif ?>
