<?php

$regionId  = (osc_item_region_id()) ? osc_item_region_id() : osc_user_region_id();
$cityId   = (osc_item_city_id()) ? osc_item_city_id() : osc_user_city_id();
$city     = (osc_item_city()) ? osc_item_city() : osc_user_city();

$colLabel = __get('col_label');
$colInput = __get('col_input');

if (__get("location_style")) {

    $cities = null;
    if (Session::newInstance()->_getForm('regionId') != "") {
        $cities = City::newInstance()->findByRegion(Session::newInstance()->_getForm('regionId'));
    } elseif ($cities == null && $regionId) {
        $cities = City::newInstance()->findByRegion($regionId);
    }

    if (count($cities) >= 1) {
        $data = array("id" => "cityId");
        $value = array();
        $value['default']   = __("Select a city...", osc_current_web_theme());
        $value['choices']   = $cities;
        $value['current']   = $cityId;
        $value['key_value'] = 'pk_i_id';
        $value['key_name']  = 's_name';
        mcf_input_generic("select", 'cityId', $value, __("City", osc_current_web_theme()), $colLabel, $colInput, $data);
    } else {
        $data = array("id" => "city");
        mcf_input_generic("text", 'city', $city, __("City", osc_current_web_theme()), $colLabel, $colInput, $data);
    }
} else {
    mcf_input_generic("text", 'city', $city, __("City", osc_current_web_theme()), $colLabel, $colInput, array('id' => 'city'));
    mcf_input_hidden("cityId", $cityId, array('id' => 'cityId'));
}