<?php if (osc_comments_enabled()) : ?>
    <?php if ((osc_reg_user_post_comments() && osc_is_web_user_logged_in()) || !osc_reg_user_post_comments()) : ?>
        <?php if (osc_plugin_is_enabled("madhouse_facebook/index.php")  && mtk_field("$.layout", "i_item_comments_facebook")) : ?>
            <div class="card">
                <div class="card-block">
                    <?php osc_run_hook('mdh_facebook_comments'); ?>
                </div>
            </div>
        <?php else : ?>
            <div class="card" id="post-comment">
                <div class="card-header">
                    <div class="pull-right">
                       <a class="btn btn-secondary" role="button" data-toggle="collapse" href="#item-add-comment" aria-expanded="true" aria-controls="collapseOne">
                            <?php _e("Add a comment", osc_current_web_theme()) ?>
                        </a>
                    </div>
                    <h2 class="h4 l-h-input m-b-0">
                        <?php _e('Comments', osc_current_web_theme()); ?>
                    </h2>
                </div>
                <div id="item-add-comment" class="panel-collapse collapse" role="tabpanel" aria-labelledby="headingOne">
                    <div class="card-block">
                        <p class="card-text text-muted">
                            <?php _e("Leave your comment (spam and offensive messages will be removed)", osc_current_web_theme()); ?>
                        </p>
                        <ul id="comment_error_list"></ul>
                        <form class="js-validate" action="<?php echo osc_base_url(true); ?>" method="post" name="comment_form" id="comment_form">
                            <?php
                            mcf_input_hidden("action", "add_comment");
                            mcf_input_hidden("page", "item");
                            mcf_input_hidden("id", osc_item_id());

                            if (osc_is_web_user_logged_in()) :
                                mcf_input_hidden("authorName", osc_esc_html(osc_logged_user_name()));
                                mcf_input_hidden("authorEmail", osc_logged_user_email());
                            else :
                                ?>
                                <div class="row">
                                    <div class="col-sm-6">
                                        <?php
                                        $data = array(
                                            "data-rule-required" => "true",
                                            "data-msg-required" => __("This field is required", osc_current_web_theme())
                                        );
                                        mcf_input_generic("text", 'authorName', "", __('Your name', osc_current_web_theme()), "", "", $data);
                                        ?>
                                    </div>
                                    <div class="col-sm-6">
                                        <?php
                                        $data = array(
                                            "data-rule-required" => "true",
                                            "data-msg-required" => __("This field is required", osc_current_web_theme()),
                                            "data-rule-email" => "true",
                                            "data-msg-email" => __("The input is not a valid email address", osc_current_web_theme())
                                        );
                                        mcf_input_generic("text", 'authorEmail', "", __('Your e-mail', osc_current_web_theme()), "", "", $data);
                                        ?>
                                    </div>
                                </div>
                                <?php
                            endif;
                            if (mtk_field("$.layout", "i_item_comments_title") == 1) :
                                $data = array(
                                    "data-rule-required"=>"true",
                                    "data-msg-required"=>__("This field is required", osc_current_web_theme())
                                );
                                mcf_input_generic("text", 'title', "", __('Title', osc_current_web_theme()), "", "", $data);
                            endif;
                            $data = array(
                                "data-rule-required" => "true",
                                "data-msg-required" => __("This field is required", osc_current_web_theme())
                            );
                            mcf_input_generic("textarea", 'body', "", __('Comment', osc_current_web_theme()), "", "", $data);

                            if (osc_plugin_is_enabled("nocaptcha_recaptcha/index.php")) :
                                mcf_show_recaptcha();
                            endif;

                            mcf_button(__('Send', osc_current_web_theme()), "btn-primary btn-block", "", "");
                            ?>
                        </form>
                    </div>
                </div>
                <?php if (osc_count_item_comments() >= 1) : ?>
                    <div class="list-group">
                        <?php while (osc_has_item_comments()) : ?>
                            <div class="list-group-item">
                                <div class="media">
                                    <?php if (function_exists("mdh_avatar_normal_url")) :?>
                                        <div class="media-left">
                                            <a href="<?php echo osc_user_public_profile_url(osc_comment_user_id()); ?>">
                                                <img class="img-avatar" src="<?php echo mdh_avatar_thumbnail_url() ?>">
                                            </a>
                                        </div>
                                    <?php endif; ?>
                                    <div class="media-body">
                                        <?php if (osc_comment_user_id() && (osc_comment_user_id() == osc_logged_user_id())) : ?>
                                            <span class="pull-right">
                                                <a class="btn btn-danger btn-sm btn-outline" rel="nofollow" href="<?php echo osc_delete_comment_url(); ?>" title="<?php _e('Delete your comment', osc_current_web_theme()); ?>"><?php _e('Delete', osc_current_web_theme()); ?></a>
                                            </span>
                                        <?php endif; ?>
                                        <?php if (osc_comment_title() != "") :  ?>
                                            <h4 class="media-heading l-h-input-sm">
                                                <div>
                                                    <?php echo osc_comment_title(); ?>
                                                </div>
                                            </h4>
                                        <?php endif; ?>
                                        <a href="<?php echo osc_user_public_profile_url(osc_comment_user_id()); ?>"><?php printf(__("By %s", osc_current_web_theme()), osc_comment_author_name()); ?></a>,&nbsp;<span class="text-muted text-xs"><?php echo osc_comment_pub_date() ?></span>
                                        <p class="m-b-0"><?php echo nl2br(osc_comment_body()); ?> </p>
                                    </div>
                                </div>
                            </div>
                        <?php endwhile; ?>
                    </div>
                <?php endif; ?>
            </div>
            <div class="paginate">
                <?php echo mcf_comments_pagination(); ?>
            </div>
        <?php endif; ?>
    <?php else : ?>
        <div class="card">
            <div class="card-header">
                <div class="pull-right">
                   <a class="btn btn-secondary" href="<?php echo osc_user_login_url() ?>#post-comment">
                        <?php _e("Login to post a comment", osc_current_web_theme()) ?>
                    </a>
                </div>
                <h2 class="h4 l-h-input m-b-0">
                    <?php _e('Comments', osc_current_web_theme()); ?>
                </h2>
            </div>
        </div>
    <?php endif; ?>
<?php endif; ?>