<?php
/*
 * Block Name: User block
 * Block Slug: user_details
 * Description: Blablabla.
 * Widget Hooks: dashboard_sidebar
 */ ?>

<div class="card card-flat card-user">
    <div class="card-block text-center">
        <?php if (function_exists("mdh_avatar_normal_url")) :?>
            <div class="m-b">
                <img class="img-avatar" src="<?php echo mdh_avatar_preview_url(osc_logged_user_id()) ;?>" />
            </div>
        <?php endif; ?>
        <h2 class="h3 title-special text-ellipsis"><?php echo osc_logged_user_name() ?></h2>
    </div>
    <ul class="list-group text-center m-b-lg">
        <?php if (osc_user_phone() !== '') : ?>
            <li class="list-group-item text-muted">
                <?php echo osc_user_phone() ?>
            </li>
        <?php endif; ?>

        <?php
        $location = mcf_user_location();
        $address = mcf_user_address();
        if (osc_user_website() !== '') : ?>
            <li class="website list-group-item">
                <a rel="nofollow" href="<?php echo osc_user_website(); ?>" target="_blank">
                    <?php echo osc_user_website(); ?>
                </a>
            </li>
        <?php                                                                                                                                                                                                                 endif; ?>
        <?php if ($address !== '' || $location !== '') : ?>
        <li class="adress text-muted list-group-item">
            <?php if ($address !== '') : ?>
            <div class="m-b-sm">
                <?php echo $address; ?>
            </div>
            <?php endif;
if ($location !== '') : ?>
                <?php echo mcf_user_location(); ?>
            <?php             endif; ?>
        </li>
        <?php endif; ?>
    </ul>
    <div class="card-block">
        <a class="btn btn-primary btn-outline btn-block" href="<?php echo osc_user_public_profile_url(osc_logged_user_id()) ?>"><?php _e("Public Profile", osc_current_web_theme()) ?></a>
    </div>
</div>
