<?php
/*
 * Block Name: Latest Items
 * Block Slug: homepage_latest_item
 * Description: Blablabla.
 * Widget Hooks: homepage
 */ ?>

<div class="section section-astride latest-items" id="latest-items">
    <div class="container">
        <div class="pos-relative">
            <h2 class="text-center d-ib m-b-lg">
                <span class="text-white"><?php _e("Latest items", osc_current_web_theme()) ?></span>
            </h2>
            <ul class="nav nav-pills pull-right">
                <li class="<?php echo (Params::getParam("sShowAs") == "list")? "active": "" ?>" rel="nofollow">
                    <a href="<?php echo osc_base_url(true); ?>?sShowAs=list#latest-items">
                        <i class="ion-navicon-round"></i>&nbsp;<span><?php _e('List', osc_current_web_theme()); ?></span>
                    </a>
                </li>
                <li
                    class="<?php echo (Params::getParam("sShowAs") == "gallery")? "active": "" ?>">
                    <a href="<?php echo osc_base_url(true); ?>?sShowAs=gallery#latest-items" rel="nofollow">
                        <i class="ion-grid"></i>&nbsp;<span><?php _e('Grid', osc_current_web_theme()); ?></span>
                    </a>
                </li>
            </ul>

            <?php if (osc_count_latest_items() == 0) : ?>
                <p class="text-white"><?php _e("There aren't listings available at this moment", osc_current_web_theme()); ?></p>
            <?php else :?>
                <div class="row <?php echo (mtk_field("$.design", "i_masonry") && Params::getParam("sShowAs") != "list") ? "js-masonry" : "" ?>">
                    <?php
                    View::newInstance()->_exportVariableToView("sShowAs", Params::getParam("sShowAs"));
                    View::newInstance()->_exportVariableToView("listType", "latestItems");
                    if (Params::getParam("sShowAs") == "list") {
                        View::newInstance()->_exportVariableToView("col", "col-xs-12");
                    } else {
                        $class = 'col-xs-12 col-sm-3 col-md-3';
                        $class .= (mtk_field("$.design", "i_masonry")) ? " grid-item" : "";
                        View::newInstance()->_exportVariableToView("col", $class);
                    }
                    osc_current_web_theme_path('parts/loop/loop.php');
                    View::newInstance()->_exportVariableToView("sShowAs", "");
                    ?>
                </div>
                <?php
endif;
            ?>
        </div>
        <div class="text-center">
            <a class="btn btn-outline btn-primary" href="<?php echo osc_search_url() ?>">
                <?php _e("View all listings", osc_current_web_theme()) ?>
            </a>
        </div>
    </div>
</div>
