<?php
/*
 * Block Name: Categories Megamenu
 * Block Slug: categories_megamenu
 * Description: Blablabla.
 * Widget Hooks: header
 */ ?>

<?php if (!mtk_is_user_page()) : ?>
    <nav class="navbar navbar-primary r-0">
        <div class="container">
        <div class="navbar-header">
            <div class="navbar-brand visible-xs-block">
                <span class="d-ib font-bold"><?php _e("Categories", osc_current_web_theme()); ?></span>
            </div>
            <button type="button" class="navbar-toggle" data-toggle="collapse" data-target=".navbar-megamenu">
                <span class="icon"></span>
            </button>
        </div>
        <div class="navbar-collapse collapse navbar-megamenu">
            <ul class="nav navbar-nav hover-animated">
                <?php osc_goto_first_category(); ?>
                <?php while (osc_has_categories()) : ?>
                    <?php
                    $categoryName = osc_category_name();
                    $categoryUrl = osc_search_category_url();
                    ?>
                    <li class="dropdown dropdown-large dropdown-large-center">
                        <a href="#" class="dropdown-toggle" data-toggle="dropdown" role="button" aria-expanded="false">
                            <?php echo $categoryName; ?><span class="caret"></span>
                        </a>

                        <ul class="dropdown-menu hover-animated">
                            <li>
                                <ul class="megamenu row">
                                    <li class="col-xs-12">
                                        <div class="p-x p-b clearfix">
                                            <a class="btn btn-secondary btn-outline pull-left" href="<?php echo $categoryUrl ?>">
                                                <?php printf(__("View all in %s", osc_current_web_theme()), strtolower($categoryName)) ?>
                                            </a>
                                        </div>
                                    </li>
                                    <?php while (osc_has_subcategories()) : ?>
                                        <li class="col-sm-4 col-xs-12">
                                            <a href="<?php echo osc_search_category_url(); ?>"><?php echo osc_category_name(); ?></a>
                                        </li>
                                    <?php endwhile; ?>
                                </ul>
                            </li>
                        </ul>
                    </li>
                <?php endwhile; ?>
            </ul>
        </div>
        </div>
    </nav>
<?php endif ?>