<?php
/*
 * Block Name: Categories Dropdown Simple
 * Block Slug: categories_dropdown_simple
 * Description: Blablabla.
 * Widget Hooks: header
 */ ?>

<?php if (!mtk_is_user_page()) : ?>
    <nav class="navbar navbar-primary">
        <div class="container">
            <!-- Brand and toggle get grouped for better mobile display -->
            <div class="navbar-header">
                <button type="button" class="navbar-toggle collapsed" data-toggle="collapse" data-target="#bs-example-navbar-collapse-1">
                    <span class="sr-only">Toggle navigation</span>
                    <span><?php _e("Categories", osc_current_web_theme()) ?></span>
                </button>
            </div>

            <!-- Collect the nav links, forms, and other content for toggling -->
            <div class="collapse navbar-collapse" id="bs-example-navbar-collapse-1">
                <ul class="nav navbar-nav navbar-left">
                    <?php osc_goto_first_category(); ?>
                    <?php while (osc_has_categories()) : ?>
                        <?php
                        $categoryName = osc_category_name();
                        $categoryUrl = osc_search_category_url();
                        ?>
                        <li class="dropdown">
                            <a href="<?php echo $categoryUrl; ?>" class="dropdown-toggle" role="button" aria-expanded="false"><?php echo $categoryName; ?><span class="caret"></span></a>
                            <ul class="dropdown-menu hover-animated" role="menu">
                                <?php while (osc_has_subcategories()) : ?>
                                    <li class="text-ellipsis ">
                                    <a href="<?php echo osc_search_category_url(); ?>"><?php echo osc_category_name(); ?></a>
                                    </li>
                                <?php endwhile; ?>
                            </ul>
                        </li>
                    <?php endwhile; ?>
                </ul>
            </div><!-- /.navbar-collapse -->
        </div><!-- /.container-fluid -->
    </nav>
<?php endif; ?>