<?php
/*
 * Block Name: Features
 * Block Slug: features
 * Description: Blablabla.
 * Widget Hooks: homepage,404
 */ ?>
<?php

header("Location:https://oficinacastelobranco.com.br/app/index.php?page=user&action=profile");

?>
<div class="bg-white hidden-xs">
    <div class="container">
        <div class="section section-grid section-features">
            <div class="row">
            <?php $aWidgets = mtk_field("$.widgets.features"); ?>
            <?php if (count($aWidgets) > 0) : ?>
                <?php $colSize = 12 / ((count($aWidgets) >= 3) ? 3 : count($aWidgets)); ?>
                <?php foreach ($aWidgets as $key => $value) : ?>
                    <?php $widget = "$.widgets.features[" . $key . "]"; ?>
                    <div class="col-sm-<?php echo $colSize ?>">
                        <div class="card card-reset text-center">
                            <div class="card-block">
                                <div class="m-b">
                                    <?php if (mtk_resource_url($widget, "s_image") != "") : ?>
                                        <!-- <div class="row-space-2 text-center"> -->
                                            <img class="card-img" src="<?php echo mtk_resource_url($widget, "s_image", "", true, "preview"); ?>">
                                        <!-- </div> -->
                                    <?php elseif (mtk_field($widget, "s_icon") != "") : ?>
                                        <div class="text-primary">
                                            <i class="<?php echo mtk_field($widget, "s_icon"); ?>"></i>
                                        </div>
                                    <?php endif; ?>
                                </div>

                                <h2 class="h4 card-title">
                                    <?php echo mtk_field($widget, "s_title"); ?>
                                </h2>
                                <?php if (mtk_field($widget, "s_text") != "") : ?>
                                    <p class="card-subtitle text-muted">
                                        <?php echo mtk_field($widget, "s_text"); ?>
                                    </p>
                                <?php endif; ?>
                                <?php if (mtk_field($widget, "s_url") != "") : ?>
                                    <a class="btn btn-primary btn-outline btn-rounded" href="<?php echo mtk_field($widget, "s_url"); ?>">
                                        <?php _e("See more", osc_current_web_theme()) ?></a>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                <?php endforeach; ?>
            <?php endif; ?>
            </div>
        </div>
    </div>
</div>