<?php
/*
 * Block Name: Dashboard profile filling rate
 * Block Slug: dashboard_profile_filling_rate.php
 * Description: Blablabla.
 * Widget Hooks: dashboard_content, dashboard_sidebar
 */ ?>

<?php $filling = mcf_profile_filling_rate(); ?>
<div class="card">
    <h3 class="card-header h5 m-b-0">
        <span><?php _e("Profile filling rate", osc_current_web_theme()) ?></span>
    </h3>
    <div class="card-block">
        <div class="text-muted">
            <?php if ($filling['rate'] == 100) : ?>
                <span><?php _e("Your profile is fully complete.", osc_current_web_theme()) ?></span>
            <?php else : ?>
                <ul>
                    <?php foreach ($filling["messages"] as $value) : ?>
                        <li><?php echo $value; ?></li>
                    <?php endforeach; ?>
                </ul>
            <?php endif; ?>
        </div>

        <div class="progress text-color bg-lprimary">
            <div class="progress-bar progress-bar-striped overlay-wrapper r-0 active" style="width: <?php echo $filling['rate']; ?>%;" role="progressbar" aria-valuenow=" <?php echo $filling['rate']; ?>" aria-valuemin="0" aria-valuemax="100">
                <div class="overlay overlay-top-0 overlay-right-0 overlay-left-0">
                    <div class="">
                        <span><?php echo round($filling['rate']); ?>%</span>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="card-footer">
        <a class="btn btn-outline btn-primary" href="<?php echo osc_user_profile_url(); ?>"><?php _e("Update my profile", osc_current_web_theme()); ?></a>
    </div>
</div>