<?php
    /**
     * Head location:   base.php
     * Header location: parts/header.php
     * Footer location: parts/footer.php
     */
?>
<?php osc_add_hook("content", function () {
    ?>

    <div class="bg-gradient jumbotron">
        <div class="container">
            <div class="row">
                <div class="col-sm-12 jumbo text-white text-center">
                    <h1 class="m-b-0"><?php echo osc_static_page_title(); ?></h1>
                </div>
            </div>
        </div>
    </div>

    <div class="container">
        <div class="row p-y-lg">
            <div class="col-sm-3">
                <ul class="nav nav-pills nav-stacked">
                    <?php
                    $currentPage = __get("page");
                    osc_reset_static_pages();
                    while (osc_has_static_pages()) :
                    ?>
                        <li class="<?php echo ($currentPage["s_internal_name"] == osc_static_page_slug())?"active":"" ?>">
                            <a href="<?php echo osc_static_page_url(); ?>"><?php echo osc_static_page_title(); ?></a>
                        </li>
                    <?php
                    endwhile;
                    View::newInstance()->_erase("pages");
                    View::newInstance()->_exportVariableToView("page", $currentPage);
                    ?>
                    <li>
                        <a href="<?php echo osc_contact_url(); ?>">
                            <?php _e('Contact', osc_current_web_theme()); ?>
                        </a>
                    </li>
                </ul>
            </div>
            <div class="col-sm-9">
                <div class="card">
                    <div class="card-block">
                        <?php echo osc_static_page_text(); ?>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <?php mtk_show_widgets("static_page--" . osc_static_page_slug()); ?>
<?php }); ?>
<?php osc_current_web_theme_path("base-full.php"); ?>

