<?php
    /**
     * Head location:   base.php
     * Header location: parts/header.php
     * Footer location: parts/footer.php
     *
     * The sidebar is generated with blocks set in the widget page in settings
     * Blocks location: parts/blocks/item/**
     */
?>
<?php if (Params::existParam("quick-view") && Params::getParam("quick-view") == true) : ?>
    <?php Session::newInstance()->_dropMessage('pubMessages'); ?>
    <?php osc_current_web_theme_path("parts/item/quick-view.php") ?>
<?php else: ?>
    <?php osc_add_hook("content", function () {
        ?>

        <?php
            $location = array();
        if (osc_item_city_area() !== '') {
            $location[] = osc_item_city_area();
        }
        if (osc_item_city() !== '') {
            $location[] = osc_item_city();
        }
        if (osc_item_region() !== '') {
            $location[] = osc_item_region();
        }
        if (osc_item_country() !== '') {
            $location[] = osc_item_country();
        }
        ?>
        <div class="bg-secondary text-inverse b-b b-secondary">
            <div class="container no-gutter-xs">
                <div class="row no-gutter-xs">
                    <div class="col-sm-8">
                        <div class="p-lg p-xs-x-md p-xs-y-md">
                            <div>
                                <h1 class="item-title h2 m-b-sm text-ellipsis">
                                    <?php echo mtk_title(); ?>
                                </h1>
                            </div>
                            <div class="item-sub-title font-secondary text-ellipsis">
                                <?php if (osc_item_is_premium()): ?>
                                    <span class="label label-premium m-r"><?php _e("Premium listing", osc_current_web_theme()) ?></span>
                                <?php endif; ?>
                                <span class="<?php echo (count($location) > 0) ? "m-r" : ""; ?>">
                                    <i class="ion-bookmark m-r-sm"></i><?php echo osc_item_category(); ?>
                                </span>
                                <?php if (count($location) > 0) : ?>
                                    <span class=""><i class="ion-location m-r-sm"></i><?php echo implode(', ', $location); ?></span>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                    <div class="col-sm-4">
                        <div class="bg-secondary lt item-details">
                            <div class="p-lg p-xs-x-md p-xs-y-md">
                                <?php if (osc_price_enabled_at_items()) : ?>
                                     <span class="h2 text-ellipsis m-b-sm item-price"><?php echo osc_item_formated_price(); ?></span>
                                <?php endif; ?>
                                <?php if (mcf_voting_can_vote()) : ?>
                                    <?php mcf_voting_result(); ?>
                                <?php else: ?>
                                    &nbsp;
                                <?php endif ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="container no-gutter-xs bg-light dk b-b visible-xs-block">
            <div class="hpadder-md">
                <div class="p-x-sm">
                    <div class="row row-xs m-b-sm">
                        <div class="col-xs-6">
                            <button type="button" class="btn btn-primary btn-sharp btn-sm btn-block" data-toggle="modal" data-target="#modalContact">
                                <?php _e('Contact', osc_current_web_theme()) ?>
                            </button>
                        </div>
                        <div class="col-xs-6">
                            <button type="button" class="btn btn-secondary btn-sharp btn-sm btn-block" data-toggle="modal" data-target="#modalSendFriend">
                                    <i class="ion-paper-airplane"></i>&nbsp;<?php _e('Send to a friend', osc_current_web_theme()) ?>
                            </button>
                        </div>
                    </div>
                </div>
                <div class="social-links text-center">
                    <?php osc_current_web_theme_path("parts/item/share.php") ?>
                </div>
            </div>
        </div>
        <div class="container no-gutter-xs">
            <?php
                /*
                 * Widgets: item_top.
                 */
                mtk_show_widgets("item_top");
            ?>
            <div class="hpadder-lg row no-gutter-xs">

                <?php if (osc_count_item_resources() > 0 || (osc_plugin_is_enabled("google_maps/index.php") && (osc_item_latitude() != "" && osc_item_longitude() != ""))) : ?>
                    <div class="col-sm-12 col-md-8">
                        <div class="custom-tabs">
                            <ul id="js-item-tabs" class="nav nav-tabs nav-underline text-md" role="tablist">
                                <?php if (osc_count_item_resources() > 0) : ?>
                                    <li role="presentation" class="active">
                                        <a href="#images" data-toggle="tab">
                                            <i class="ion-ios-camera"></i> <?php _e("Images", osc_current_web_theme()) ?>
                                        </a>
                                    </li>
                                <?php endif; ?>
                                <?php if (osc_plugin_is_enabled("google_maps/index.php") && osc_item_latitude() != "" && osc_item_longitude() != "") : ?>
                                    <li role="presentation" class="<?php echo (osc_count_item_resources() == 0) ? "active" : "" ?>">
                                        <a href="#map" data-toggle="tab">
                                            <i class="ion-map"></i> <?php _e("Map", osc_current_web_theme()) ?>
                                        </a>
                                    </li>
                                <?php endif; ?>
                            </ul>
                            <div class="tab-content">
                                <?php if (osc_count_item_resources() > 0) : ?>
                                    <div role="tabpanel" class="tab-pane active" id="images">
                                        <div class="panel">
                                            <div class="p-md item-carousel">
                                                <?php if (mtk_field("layout", "i_item_pictures_mode") == 1) : ?>
                                                    <?php osc_current_web_theme_path('parts/item/lightbox.php'); ?>
                                                <?php else : ?>
                                                    <?php osc_current_web_theme_path('parts/item/carousel.php'); ?>
                                                <?php endif; ?>
                                            </div>
                                        </div>
                                    </div>
                                <?php endif; ?>
                                <?php if (osc_plugin_is_enabled("google_maps/index.php") && osc_item_latitude() != "" && osc_item_longitude() != "") : ?>
                                    <div role="tabpanel" class="tab-pane <?php echo (osc_count_item_resources() == 0) ? "active" : "" ?>" id="map">
                                        <div class="panel item-location">
                                            <div class="p-md">
                                                <?php $item = osc_item(); ?>
                                                <?php require osc_plugin_path('') . "google_maps/map.php"; ?>
                                            </div>
                                        </div>
                                    </div>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                <?php endif; ?>
                <div class="pull-right col-md-4 col-sm-5 col-xs-12">
                    <?php mtk_show_widgets("item_sidebar"); ?>
                    <?php osc_run_hook('mcf_item_sidebar', osc_item()); ?>
                </div>
                <div class="pull-left col-md-8 col-sm-7 col-xs-12">
                    <?php osc_current_web_theme_path('parts/item/details.php'); ?>
                    <?php osc_current_web_theme_path('parts/item/comment.php'); ?>
                </div>
            </div>
        </div>
        <div class="container">
            <?php
                /*
                 * Widgets: item_bottom.
                 */
                mtk_show_widgets("item_bottom");
            ?>
        </div>
        <?php View::newInstance()->_exportVariableToView('listType', 'customItems'); ?>
        <?php if (mcf_related_listings() > 0) : ?>
            <div class="section section-astride item-related-listings">
                <div class="container">
                    <h2 class="m-b-lg pos-relative">
                        <span class="text-white"><?php _e('Related listings', osc_current_web_theme()); ?></span>
                    </h2>
                    <?php osc_current_web_theme_path('parts/loop/loop-carousel.php'); ?>
                </div>
            </div>
        <?php endif; ?>
    <?php }); ?>

    <?php osc_current_web_theme_path("base-full.php"); ?>

    <script>
    $(document).ready(function(){

        $('.nav-tabs').on('shown.bs.tab', function () {
                lastCenter=map.getCenter();
                google.maps.event.trigger(window, 'resize', {});
                map.setCenter(lastCenter);
        });
    });
     </script>
<?php endif ?>
