<?php
    /**
     * Head location:   base.php
     * Header location: parts/header.php
     * Footer location: parts/footer.php
     */
?>

<?php osc_add_hook("content", function () {
    ?>
    <div class="bg-gradient jumbotron">
        <div class="container">
            <div class="row">
                <div class="col-sm-12 jumbo text-white text-center">
                    <h1 class="m-b-0"><?php echo mtk_title(); ?></h1>
                </div>
            </div>
        </div>
    </div>

    <div class="container">
        <div class="row p-y-lg">
            <div class="col-sm-3">
                <ul class="nav nav-pills nav-stacked">
                    <?php
                    osc_reset_static_pages();
                    while (osc_has_static_pages()) :
                    ?>
                        <li class="">
                            <a href="<?php echo osc_static_page_url(); ?>"><?php echo osc_static_page_title(); ?></a>
                        </li>
                    <?php
                    endwhile;
                    View::newInstance()->_erase("pages");
                    ?>
                    <li class="active">
                        <a href="<?php echo osc_contact_url(); ?>">
                            <?php _e('Contact', osc_current_web_theme()); ?>
                        </a>
                    </li>
                </ul>
            </div>
            <div class="col-sm-9">
                <div class="card">
                    <div class="card-block">
                        <form class="js-validate" name="contact_form" action="<?php echo osc_base_url(true); ?>" method="post">
                            <?php
                            mcf_input_hidden("page", "contact");
                            mcf_input_hidden("action", "contact_post");

                            $data = array(
                                "data-rule-required"=>"true",
                                "data-msg-required"=>__("This field is required", osc_current_web_theme())
                            );

                            mcf_input_generic("text", 'yourName', "", __("Your name", osc_current_web_theme()), "", "", $data);

                            $data = array(
                                "data-rule-required"=>"true",
                                "data-msg-required"=>__("This field is required", osc_current_web_theme()),
                                "data-rule-email"=>"true",
                                "data-msg-email"=>__("The input is not a valid email address", osc_current_web_theme())
                            );
                            mcf_input_generic("text", 'yourEmail', "", __("Your email", osc_current_web_theme()), "", "", $data);
                            mcf_input_generic("text", 'subject', "", __("Subject", osc_current_web_theme()), "", "");
                            $data = array(
                                "data-rule-required"=>"true",
                                "data-msg-required"=>__("This field is required", osc_current_web_theme())
                            );
                            mcf_input_generic("textarea", 'message', "", __("Message", osc_current_web_theme()), "", "", $data);

                            if (osc_contact_attachment()):
                                mcf_input_generic("file", "attachment", "", __("Attachment", osc_current_web_theme()), "", "", $data);
                            endif;

                            osc_run_hook('contact_form');

                            mcf_show_recaptcha();

                            mcf_button(__('Send', osc_current_web_theme()), "btn-block btn-primary", ""); ?>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php }); ?>

<?php osc_current_web_theme_path("base-full.php"); ?>
