<?php

class Madhouse_Mcfly_Theme
{
    /**
     * Current version of this theme
     *
     * @since 1.2.0
     */
    const CURRENT_VERSION   = "1.6.2";

    /**
     * Install (activate) the theme.
     *
     * This will try to install themekitchen and complain if something goes
     * wrong in the process.
     *
     * @return void
     *
     * @since  1.0.1
     */
    public static function install()
    {
        $oldVersion = osc_get_preference("version", "theme_" . osc_current_web_theme());
        $newVersion = "1.0.0";
        if ($oldVersion == "") {
            try {
                // Install ThemeKitchen.
                Madhouse_ThemeKitchen_Package::install();

                // Set version.
                osc_set_preference("version", $newVersion, "theme_".osc_current_web_theme());
                osc_reset_preferences();
            } catch (Exception $e) {
                osc_add_flash_warning_message(__("Something went wrong while installing theme settings", osc_current_web_theme()), "admin");
            }
        }
    }

    /**
     * Upgrage the theme.
     *
     * @return void
     *
     * @since  1.0.1
     */
    public static function upgrade()
    {
        $currentVersion = osc_get_preference("version", "theme_" . osc_current_web_theme());
        if ($currentVersion != "") {
            // Launch every upgrade.
            self::upgrade101();
            self::upgrade102();
            self::upgrade103();
            self::upgrade104();
            self::upgrade110();
            self::upgrade120();
            self::upgrade130();
            self::upgrade140();
            self::upgrade150();
            self::upgrade160();
        }
    }

    /**
     * Update to v1.0.1.
     *
     * @return void
     *
     * @since  1.0.1
     */
    public static function upgrade101()
    {
        $oldVersion = osc_get_preference("version", "theme_".osc_current_web_theme());
        $newVersion = "1.0.1";

        if (version_compare($oldVersion, $newVersion) < 0) {
            // Upgrade the version to $newVersion
            osc_set_preference("version", $newVersion, "theme_" . osc_current_web_theme());
            osc_reset_preferences();
        }
    }

    /**
     * Update to v1.0.2.
     *
     * @return void
     *
     * @since  1.0.2
     */
    public static function upgrade102()
    {
        $oldVersion = osc_get_preference("version", "theme_".osc_current_web_theme());
        $newVersion = "1.0.2";

        if (version_compare($oldVersion, $newVersion) < 0) {
            // Retrieve the current configuration.
            $configurationService = Madhouse_ThemeKitchen_Services_StaticConfigurationService::newInstance();
            $configurationObject = $configurationService->findConfigurationBy();

            // Update widget hooks for 'b_filters_enabled'.
            foreach ($configurationObject->get("widget_hooks") as $index => $widgetHook) {
                if (in_array($widgetHook["s_slug"], array("search_top", "search_bottom", "search_sidebar"))) {
                    // Set default to the object.
                    $configurationObject->set(
                        array("widget_hooks", $index, "b_filters_enabled"),
                        true
                    );
                }
            }

            // Update configuration.
            $configurationService->updateConfiguration($configurationObject);

            // Upgrade the version to $newVersion
            osc_set_preference("version", $newVersion, "theme_" . osc_current_web_theme());
            osc_reset_preferences();
        }
    }

    /**
     * Update to v1.0.3.
     *
     * @return void
     *
     * @since  1.0.3
     */
    public static function upgrade103()
    {
        $oldVersion = osc_get_preference("version", "theme_" . osc_current_web_theme());
        $newVersion = "1.0.3";

        if (version_compare($oldVersion, $newVersion) < 0) {
            // Upgrade the version to $newVersion
            osc_set_preference("version", $newVersion, "theme_" . osc_current_web_theme());
            osc_reset_preferences();
        }
    }

    /**
     * Update to v1.0.4.
     *
     * @return void
     *
     * @since  1.0.4
     */
    public static function upgrade104()
    {
        $oldVersion = osc_get_preference("version", "theme_" . osc_current_web_theme());
        $newVersion = "1.0.4";

        if (version_compare($oldVersion, $newVersion) < 0) {
            // Upgrade the version to $newVersion
            osc_set_preference("version", $newVersion, "theme_" . osc_current_web_theme());
            osc_reset_preferences();
        }
    }

    /**
     * Update to v1.1.0.
     *
     * @return void
     *
     * @since  1.1.0
     */
    public static function upgrade110()
    {
        $oldVersion = osc_get_preference("version", "theme_" . osc_current_web_theme());
        $newVersion = "1.1.0";

        if (version_compare($oldVersion, $newVersion) < 0) {
            // Upgrade the version to $newVersion
            osc_set_preference("version", $newVersion, "theme_" . osc_current_web_theme());
            osc_reset_preferences();
        }
    }

    /**
     * Update to v1.2.0.
     *
     * @return void
     *
     * @since  1.2.0
     */
    public static function upgrade120()
    {
        $oldVersion = osc_get_preference("version", "theme_" . osc_current_web_theme());
        $newVersion = "1.2.0";

        if (version_compare($oldVersion, $newVersion) < 0) {
            // Upgrade the version to $newVersion
            osc_set_preference("version", $newVersion, "theme_" . osc_current_web_theme());
            osc_reset_preferences();
        }
    }

    /**
     * Update to v1.3.0.
     *
     * @return void
     *
     * @since  1.3.0
     */
    public static function upgrade130()
    {
        $oldVersion = osc_get_preference("version", "theme_" . osc_current_web_theme());
        $newVersion = "1.3.0";

        if (version_compare($oldVersion, $newVersion) < 0) {
            // Upgrade the version to $newVersion
            osc_set_preference("version", $newVersion, "theme_" . osc_current_web_theme());
            osc_reset_preferences();
        }
    }

    /**
     * Update to v1.4.0.
     *
     * @return void
     *
     * @since  1.3.0
     */
    public static function upgrade140()
    {
        $oldVersion = osc_get_preference("version", "theme_" . osc_current_web_theme());
        $newVersion = "1.4.0";

        if (version_compare($oldVersion, $newVersion) < 0) {
            // Upgrade the version to $newVersion
            osc_set_preference("version", $newVersion, "theme_" . osc_current_web_theme());
            osc_reset_preferences();
        }
    }

    /**
     * Update to v1.5.0
     *
     * @return void
     *
     * @since 1.5.0
     */
    public static function upgrade150()
    {
        $oldVersion = osc_get_preference("version", "theme_" . osc_current_web_theme());
        $newVersion = "1.5.0";

        if (version_compare($oldVersion, $newVersion) < 0) {
            /*
             * Update configuration with styles configuration.
             */

            // Retrieve the current configuration.
            $configurationService = Madhouse_ThemeKitchen_Services_StaticConfigurationService::newInstance();
            $configurationObject = $configurationService->findConfigurationBy();

            // Set default to the object.
            $configurationObject->set(
                "$.styles",
                array(
                    "path" => "assets/css/dist",
                    "type" => "scss",
                    "options" => array(
                        "include_paths" => array(
                            "vendor/bower_components",
                            "assets/css"
                        ),
                    )
                )
            );

            // Update configuration.
            $configurationService->updateConfiguration($configurationObject);

            /*
             * Update settings with new design settings.
             */

            // Get the settings service.
            $settingsService = Madhouse_ThemeKitchen_Services_SettingsService::newInstance();

            // Retrieve settings from database.
            $currentSettings = $settingsService->findSettingsBy();

            // Set new settings.
            $currentSettings->set("$.design.i_content_boxed", 0);
            $currentSettings->set("$.design.i_navbar_large", 1);
            $currentSettings->set("$.design.i_masonry", 1);
            $currentSettings->set("$.design.i_search_parallax", 1);

            // Update settings @ database.
            $settingsService->updateSettings($currentSettings);

            // Upgrade the version to $newVersion
            osc_set_preference("version", $newVersion, "theme_" . osc_current_web_theme());
            osc_reset_preferences();
        }
    }

    /**
     * Update to v1.6.0.
     *
     * @return void
     *
     * @since  1.6.0
     */
    public static function upgrade160()
    {
        $oldVersion = osc_get_preference("version", "theme_" . osc_current_web_theme());
        $newVersion = "1.6.0";

        if (version_compare($oldVersion, $newVersion) < 0) {
            // Get the settings service.
            $settingsService = Madhouse_ThemeKitchen_Services_SettingsService::newInstance();

            // Retrieve settings from database.
            $currentSettings = $settingsService->findSettingsBy();

            // Set new settings.
            $currentSettings->set("$.design.i_navbar_inverse", 0);

            // Update settings @ database.
            $settingsService->updateSettings($currentSettings);

            // Upgrade the version to $newVersion
            osc_set_preference("version", $newVersion, "theme_" . osc_current_web_theme());
            osc_reset_preferences();
        }

        $oldVersion = osc_get_preference("version", "theme_" . osc_current_web_theme());
        $newVersion = "1.6.1";

        if (version_compare($oldVersion, $newVersion) < 0) {
            // Upgrade the version to $newVersion
            osc_set_preference("version", $newVersion, "theme_" . osc_current_web_theme());
            osc_reset_preferences();
        }

        $oldVersion = osc_get_preference("version", "theme_" . osc_current_web_theme());
        $newVersion = "1.6.2";

        if (version_compare($oldVersion, $newVersion) < 0) {
            // Upgrade the version to $newVersion
            osc_set_preference("version", $newVersion, "theme_" . osc_current_web_theme());
            osc_reset_preferences();
        }
    }

    /**
     * Init the theme.
     *
     * This will launch the upgrade process if necessary.
     *
     * @return void
     *
     * @since  1.0.1
     */
    public static function init()
    {
        self::upgrade();
    }
}
