// gettext is already loaded here,
// so _ variable points to Gettext instance

var underscore = _.noConflict();

(function($) {

    $.osclassAjaxSearch = function(element, options) {
        /**
         * Shorthand function for i18n (PHP copy-cat of __).
         * @param  String msgid Key / English sentence to be translated.
         * @return String       Translated text.
         */
        var _ = function (msgid) {
            return gt.gettext(msgid);
        }

        var defaults = {
        };

        var plugin = this;

        plugin.settings = {};

        var $element = $(element),
            element  = element,
            depth = 0;

        plugin.init = function() {
            plugin.settings = $.extend({}, defaults, options);

            // history.pushState(
            //     getSearchData({}), null, window.location.href
            // );

            $element.on('submit', function (event) {

                var searchData = getSearchData({});
                doSearch(searchData);

                return false;
            });

            $element.on('click', '[type=submit]', function (event) {
                $('#modal-search-filters').modal('hide');
            });

            $(document).on('click', '.js-search-filter', function (event) {
                event.preventDefault();

                var searchFilter = $(this).data('search-param'),
                    searchValue = $(this).data('search-value'),
                    linkData = {};

                setValue($element.find("[name='"+searchFilter+"']"), searchValue);

                linkData[searchFilter] = searchValue;

                if (searchFilter == "iPage") {
                    $('html,body').animate({
                        scrollTop: $(".js-search-results").offset().top - 60},
                        'fast'
                    );
                }

                if (searchFilter === "sCategory") {
                    getCustomFields();
                }

                var searchData = getSearchData(linkData);
                doSearch(searchData);
            });

            window.addEventListener('popstate', function(e) {
                if (e.state == null) {
                    window.location.replace(document.referrer);
                } else {
                    //doSearch(e.state);

                    // $("input[type=checkbox]:checked").removeAttr('checked');

                    // for (var key in e.state){
                    //     elem = $("[name='"+key+"']");
                    //     setValue(elem, e.state[key]);
                    //     if (key = "sCategory") {
                    //         initCategoriesSelect(e.state[key]);
                    //     }
                    // }

                    // $(".js-price-range").slider("option", "values", [parseInt(e.state.sPriceMin), parseInt(e.state.sPriceMax)]);

                    window.location.replace(location.href);
                }
            });

            // @TODO crossbrowser event 'input' not supported by all browser.
            $element.find('input,textarea').on('input', underscore.debounce(onChangeHandler, 250));
            $element.on('change', 'select,input[type=checkbox],input[type=radio]', underscore.debounce(onChangeHandler, 100));
        }

        var doSearch = function (searchData)
        {
            $('.js-search-results').addClass('loader');
            // Call the url.
            $.ajax({
                'url': $element.attr("action"),
                'method': 'POST',
                'data': searchData,
                'success': function (data, textStatus, jqXHR) {
                },
                'error': function (jqXHR, textStatus, errorThrown) {

                },
                'complete': function (jqXHR, textStatus) {
                    data = $.parseJSON(jqXHR.responseText);
                    if (window.location.href != data.url) {
                        history.pushState(searchData, data.title, data.url);
                    }

                    if (typeof(_gaq) != 'undefined') {
                        _gaq.push(['_trackPageview', data.url]);
                    }
                    generateResult(data);
                }
            });
        }

        var generateResult = function (data)
        {

            document.title = data.title;

            $('.js-search-categories-refine').html(data.categories_links);

            $('.js-search-header').html(data.header);
            $('.js-search-results').html(data.results);

            $('input[name="alert"]').val(data.alert);

            $('.js-masonry').imagesLoaded(function() {
                $('.js-masonry').masonry({
                    // options...
                    itemSelector: '.grid-item'
                });
            });

            $element.find('.js-price-range').slider( "option", "max", data.price_max);

            $(".js-slider-item-small").slick({
                slidesToShow: 3,
                slidesToScroll: 3,
                edgeFriction: 0.1,
                infinite: true,
                responsive: [{
                    breakpoint: 991,
                    settings: {
                        slidesToShow: 2,
                        slidesToScroll: 2
                    }
                }, {
                    breakpoint: 480,
                    settings: {
                        slidesToShow: 1,
                        arrows: true,
                        slidesToScroll: 1
                    }
                }]
            });

            $('.js-slider-search').slick({
                slidesToShow: 1,
                slidesToScroll: 1,
                arrows: true,
                edgeFriction: 0.1,
                infinite: true,
                autoplay: false,
                lazyLoad: 'ondemand'
            });
            $('.js-search-results').removeClass('loader');
        }

        var setValue = function (elem, value)
        {
            if (elem.attr('type') == 'radio' || elem.attr('type') == 'checkbox') {
                elem.prop('checked', true);
            } else if (elem.attr('type') == 'select') {
                elem.find("option").filter(function() {
                    //may want to use $.trim in here
                    return $(this).text() == text1;
                }).prop('selected', true);
            } else {
                elem.val(value);
            }
        }

        var getSearchData = function (extra)
        {
            // Serialize itself to get the new search param.
            return $.extend(
                $element.serializeJSON(),
                {
                    'sFeed': 'api'
                },
                extra
            );
        }

        var onChangeHandler = function (event)
        {
            if ( $(this).attr('name') == "sRegion") {
                // Reset the city field if the region gets modified.
                $element.find('[name="sCity"]').prop("0");
            }


            if ($(this).attr('name') === "sCategory") {
                getCustomFields();
            }

            if (false == $(this).hasClass('js-submit-not')) {
                // Ready to submit the form.
                $element.submit();
            }
        }

        plugin.init();
    }

    $.fn.osclassAjaxSearch = function(options) {
        return this.each(function() {
            if (undefined == $(this).data('osclassAjaxSearch')) {
                var plugin = new $.osclassAjaxSearch(this, options);
                $(this).data('osclassAjaxSearch', plugin);
            }
        });

    }

    /**
     * DATA-* ATTRIBUTES API
     *
     * Use data-* attributes to enable/configure your sheeper components.
     */
    $(document).ready(function() {
        $('[data-toggle="osclass-search-ajax"]').osclassAjaxSearch({});
    });

})(jQuery);
