<div class="bg-light b-b">
    <div class="p-lg">
        <div class="form-group">
            <label class="control-label col-sm-3">
                <?php _e("Variant", osc_current_web_theme()); ?>
            </label>
            <div class="col-sm-9">
                <?php $theme_variants = array(
                    array("s_name" => "Orange", "s_slug" => "theme1"),
                    array("s_name" => "Blue", "s_slug" => "theme2"),
                );?>
                <?php for ($i = 0; $i < count($theme_variants); ++$i) : ?>
                <label class="radio-inline">
                    <input
                        type="radio"
                        name="design[s_variant]"
                        value="<?php echo $theme_variants[$i]["s_slug"]; ?>"
                        <?php echo ($i === 0 || mtk_field("$.design", "s_variant") == $theme_variants[$i]["s_slug"]) ? 'checked="checked"' : "" ?>
                    >&nbsp;<?php echo $theme_variants[$i]["s_name"]; ?>
                </label>
                <?php endfor; ?>
                <div class="help-block">Which variant of the theme do you like?</div>
            </div>
        </div>
    </div>
</div>
<div class="">
    <div class="bg-light dk p-lg b-b">
        <h3 class="h4 font-bold text-info row-space-2">
            <?php _e("Options", osc_current_web_theme()); ?>
        </h3>
        <p><?php _e("Those various design options will allow you to enable or disable effects and tweak the theme the way you like it. ", osc_current_web_theme()); ?></p>
        <div class="form-group">
            <label class="control-label col-sm-3">
                <?php _e("Content boxed", osc_current_web_theme()); ?>
            </label>
            <div class="col-sm-9">
                <input type="checkbox" name="design[i_content_boxed]" value="1" <?php echo (mtk_field("$.design", "i_content_boxed")) ? 'checked="checked"' : "" ?> data-toggle="toggle">
                <div class="help-block"><?php _e("Wrap the whole site inside a fixed width container.", osc_current_web_theme()); ?></div>
            </div>
        </div>
        <div class="form-group">
            <label class="control-label col-sm-3">
                <?php _e("Navbar inverse", osc_current_web_theme()); ?>
            </label>
            <div class="col-sm-9">
                <input type="checkbox" name="design[i_navbar_inverse]" value="1" <?php echo (mtk_field("$.design", "i_navbar_inverse")) ? 'checked="checked"' : "" ?> data-toggle="toggle">
                <div class="help-block"><?php _e("Use a dark header", osc_current_web_theme()); ?></div>
            </div>
        </div>
        <div class="form-group">
            <label class="control-label col-sm-3">
                <?php _e("Large navbar", osc_current_web_theme()); ?>
            </label>
            <div class="col-sm-9">
                <input type="checkbox" name="design[i_navbar_large]" value="1" <?php echo (mtk_field("$.design", "i_navbar_large")) ? 'checked="checked"' : "" ?> data-toggle="toggle">
                <div class="help-block"><?php _e("Use a large navbar for the main navigation menu", osc_current_web_theme()); ?></div>
            </div>
        </div>
        <div class="form-group">
            <label class="control-label col-sm-3">
                <?php _e("Masonry", osc_current_web_theme()); ?>
            </label>
            <div class="col-sm-9">
                <input type="checkbox" name="design[i_masonry]" value="1" <?php echo (mtk_field("$.design", "i_masonry")) ? 'checked="checked"' : "" ?> data-toggle="toggle">
                <div class="help-block"><?php _e("Add Masonry grid effect on homepage and search pages, like on Tumblr blogs.", osc_current_web_theme()); ?></div>
            </div>
        </div>
        <div class="form-group">
            <label class="control-label col-sm-3">
                <?php _e("Parallax", osc_current_web_theme()); ?>
            </label>
            <div class="col-sm-9">
                <input type="checkbox" name="design[i_search_parallax]" value="1" <?php echo (mtk_field("$.design", "i_search_parallax")) ? 'checked="checked"' : "" ?> data-toggle="toggle">
                <div class="help-block"><?php _e("Enable or disable the parallax effect on large blocks such as the search cover block.", osc_current_web_theme()); ?></div>
            </div>
        </div>
    </div>
</div>
<div class="bg-light b-b">
    <div class="p-lg">
        <h3 class="h4 font-bold text-info row-space-2">
            <?php _e("Main colors", osc_current_web_theme()); ?>
        </h3>
        <p class="row-space-3"><?php _e("This section lets you customize all colors of the theme and match your brand colors or just your taste. All colors can be changed using easy-to-use colorpickers or by entering HEX color codes.", osc_current_web_theme()) ?></p>
        <!-- Custom files to be rendered. -->
        <input type="hidden" name="design[custom][primary][path]" value="<?php echo "assets/css/custom/_brand-primary.scss"; ?>" />
        <input type="hidden" name="design[custom][secondary][path]" value="<?php echo "assets/css/custom/_brand-secondary.scss"; ?>" />
        <input type="hidden" name="design[custom][dark][path]" value="<?php echo "assets/css/custom/_brand-dark.scss"; ?>" />
        <input type="hidden" name="design[custom][premium][path]" value="<?php echo "assets/css/custom/_brand-premium.scss"; ?>" />
        <input type="hidden" name="design[custom][alert_info][path]" value="<?php echo "assets/css/custom/_alert-info.scss"; ?>" />
        <input type="hidden" name="design[custom][alert_success][path]" value="<?php echo "assets/css/custom/_alert-success.scss"; ?>" />
        <input type="hidden" name="design[custom][alert_warning][path]" value="<?php echo "assets/css/custom/_alert-warning.scss"; ?>" />
        <input type="hidden" name="design[custom][alert_danger][path]" value="<?php echo "assets/css/custom/_alert-danger.scss"; ?>" />

        <div class="form-group">
            <label class="control-label col-sm-3">
                <?php _e("Primary color", osc_current_web_theme()); ?>
            </label>
            <div class="col-sm-9">
                <div class="input-group colorpicker-component js-colorpicker width-md">
                    <input class="form-control" type="text" name="design[custom][primary][variables][brand_primary]" value="<?php echo mtk_field(array("design", "custom", "primary", "variables"), "brand_primary"); ?>" />
                    <span class="input-group-addon bg-light"><i></i></span>
                </div>
                <p class="help-block">
                    <?php _e("This color is the primary color of your website and will apply on most color blocks, buttons and navigations of the theme.", osc_current_web_theme()); ?>
                </p>
            </div>
        </div>
        <div class="form-group">
            <label class="control-label col-sm-3">
                <?php _e("Secondary color", osc_current_web_theme()); ?>
            </label>
            <div class="col-sm-9">
                <div class="input-group colorpicker-component js-colorpicker width-md">
                    <input class="form-control" type="text" name="design[custom][secondary][variables][brand_secondary]" value="<?php echo mtk_field(array("design", "custom", "secondary", "variables"), "brand_secondary"); ?>" />
                    <span class="input-group-addon bg-light"><i></i></span>
                </div>
                <p class="help-block">
                    <?php _e("The secondary color is used on some buttons and blocks to add more contrast with the primary color on multiple pages like item page, public profile or conversation page (messenger).", osc_current_web_theme()); ?>
                </p>
            </div>
        </div>
        <div class="form-group">
            <label class="control-label col-sm-3">
                <?php _e("Brand dark", osc_current_web_theme()); ?>
            </label>
            <div class="col-sm-9">
                <div class="input-group colorpicker-component js-colorpicker width-md">
                    <input class="form-control" type="text" name="design[custom][dark][variables][brand_dark]" value="<?php echo mtk_field(array("design", "custom", "dark", "variables"), "brand_dark"); ?>" />
                    <span class="input-group-addon bg-light"><i></i></span>
                </div>
                <p class="help-block"><?php _e("Another contrast color used in some background (search cover), footer, or the price tag (item).", osc_current_web_theme()); ?></p>
            </div>
        </div>
    </div>
</div>
<div class="bg-light dk b-b">
    <div class="p-lg">
        <h3 class="h4 font-bold text-info row-space-2">
            <?php _e("Premium colors", osc_current_web_theme()); ?>
        </h3>
        <p class="row-space-2">
            <?php _e("By default, premium items are flashy but you can still customize that flashy color below.", osc_current_web_theme()); ?>
        </p>
        <p class="row-space-3 text-warning">
            <?php _e("Note that you need to fill both colors of each block below for the customization to work.", osc_current_web_theme())?>
        </p>
        <div class="form-group">
            <label class="control-label col-sm-3">
                <?php _e("Premium color", osc_current_web_theme()); ?>
            </label>
            <div class="col-sm-9">
                <div class="input-group colorpicker-component js-colorpicker width-md">
                    <input class="form-control" type="text" name="design[custom][premium][variables][brand_premium]" value="<?php echo mtk_field(array("design", "custom", "premium", "variables"), "brand_premium"); ?>" />
                    <span class="input-group-addon bg-light"><i></i></span>
                </div>
                <p class="help-block"><?php _e("Background color for premium tag and overlay on items.", osc_current_web_theme()); ?></p>
            </div>
        </div>
        <div class="form-group">
            <label class="control-label col-sm-3">
                <?php _e("Premium text", osc_current_web_theme()); ?>
            </label>
            <div class="col-sm-9">
                <div class="input-group colorpicker-component js-colorpicker width-md">
                    <input class="form-control" type="text" name="design[custom][premium][variables][text_premium]" value="<?php echo mtk_field(array("design", "custom", "premium", "variables"), "text_premium"); ?>" />
                    <span class="input-group-addon bg-light"><i></i></span>
                </div>
                <p class="help-block"><?php _e("Text color for premium tag and overlay on items. Choose some color that has a good contrast with the premium color above.", osc_current_web_theme()); ?></p>
            </div>
        </div>
    </div>
</div>
<div class="bg-light">
    <div class="p-lg b-b">
        <h3 class="h4 font-bold text-info row-space-2">
            <?php _e("Status colors", osc_current_web_theme()); ?>
        </h3>
        <p class="row-space-3">
            <?php _e("Colors for information, success or error messages that you can customize if you don't like the flashy default colors of the theme.", osc_current_web_theme()); ?>
        </p>
        <p class="text-warning row-space-0">
            <?php _e("Note that you need to fill both colors of each block below for the customization to work.", osc_current_web_theme())?>
        </p>
    </div>
    <div class="p-lg b-b">
        <div class="form-group">
            <label class="control-label col-sm-3">
                <?php _e("Info color", osc_current_web_theme()); ?>
            </label>
            <div class="col-sm-9">
                <div class="input-group colorpicker-component js-colorpicker width-md">
                    <input class="form-control" type="text" name="design[custom][alert_info][variables][alert_info_bg]" value="<?php echo mtk_field(array("design", "custom", "alert_info", "variables"), "alert_info_bg"); ?>" />
                    <span class="input-group-addon bg-light"><i></i></span>
                </div>
                <p class="help-block"><?php _e("Info color used as background for information messages.", osc_current_web_theme()); ?></p>
            </div>
        </div>
        <div class="form-group">
            <label class="control-label col-sm-3">
                <?php _e("Info text", osc_current_web_theme()); ?>
            </label>
            <div class="col-sm-9">
                <div class="input-group colorpicker-component js-colorpicker width-md">
                    <input class="form-control" type="text" name="design[custom][alert_info][variables][alert_info_color]" value="<?php echo mtk_field(array("design", "custom", "alert_info", "variables"), "alert_info_color"); ?>" />
                    <span class="input-group-addon bg-light"><i></i></span>
                </div>
                <p class="help-block"><?php _e("Choose some color that has a good contrast with the color above.", osc_current_web_theme()); ?></p>
            </div>
        </div>
    </div>
    <div class="p-lg b-b">
        <div class="form-group">
            <label class="control-label col-sm-3">
                <?php _e("Success color", osc_current_web_theme()); ?>
            </label>
            <div class="col-sm-9">
                <div class="input-group colorpicker-component js-colorpicker width-md">
                    <input class="form-control" type="text" name="design[custom][alert_success][variables][alert_success_bg]" value="<?php echo mtk_field(array("design", "custom", "alert_success", "variables"), "alert_success_bg"); ?>" />
                    <span class="input-group-addon bg-light"><i></i></span>
                </div>
                <p class="help-block"><?php _e("Success color used as background for success (ok) messages.", osc_current_web_theme()); ?></p>
            </div>
        </div>
        <div class="form-group">
            <label class="control-label col-sm-3">
                <?php _e("Success text", osc_current_web_theme()); ?>
            </label>
            <div class="col-sm-9">
                <div class="input-group colorpicker-component js-colorpicker width-md">
                    <input class="form-control" type="text" name="design[custom][alert_success][variables][alert_success_color]" value="<?php echo mtk_field(array("design", "custom", "alert_success", "variables"), "alert_success_color"); ?>" />
                    <span class="input-group-addon bg-light"><i></i></span>
                </div>
                <p class="help-block"><?php _e("Choose some color that has a good contrast with the color above.", osc_current_web_theme()); ?></p>
            </div>
        </div>
    </div>
    <div class="p-lg b-b">
        <div class="form-group">
            <label class="control-label col-sm-3">
                <?php _e("Warning color", osc_current_web_theme()); ?>
            </label>
            <div class="col-sm-9">
                <div class="input-group colorpicker-component js-colorpicker width-md">
                    <input class="form-control" type="text" name="design[custom][alert_warning][variables][alert_warning_bg]" value="<?php echo mtk_field(array("design", "custom", "alert_warning", "variables"), "alert_warning_bg"); ?>" />
                    <span class="input-group-addon bg-light"><i></i></span>
                </div>
                <p class="help-block"><?php _e("Warning color used as background for warning messages.", osc_current_web_theme()); ?></p>
            </div>
        </div>
        <div class="form-group">
            <label class="control-label col-sm-3">
                <?php _e("Warning text", osc_current_web_theme()); ?>
            </label>
            <div class="col-sm-9">
                <div class="input-group colorpicker-component js-colorpicker width-md">
                    <input class="form-control" type="text" name="design[custom][alert_warning][variables][alert_warning_color]" value="<?php echo mtk_field(array("design", "custom", "alert_warning", "variables"), "alert_warning_color"); ?>" />
                    <span class="input-group-addon bg-light"><i></i></span>
                </div>
                <p class="help-block"><?php _e("Choose some color that has a good contrast with the color above.", osc_current_web_theme()); ?></p>
            </div>
        </div>
    </div>
    <div class="p-lg b-b">
        <div class="form-group">
            <label class="control-label col-sm-3">
                <?php _e("Error color", osc_current_web_theme()); ?>
            </label>
            <div class="col-sm-9">
                <div class="input-group colorpicker-component js-colorpicker width-md">
                    <input class="form-control" type="text" name="design[custom][alert_danger][variables][alert_danger_bg]" value="<?php echo mtk_field(array("design", "custom", "alert_danger", "variables"), "alert_danger_bg"); ?>" />
                    <span class="input-group-addon bg-light"><i></i></span>
                </div>
                <p class="help-block"><?php _e("Error colors used as background for error messages and as color for errors on a form field.", osc_current_web_theme()); ?></p>
            </div>
        </div>
        <div class="form-group">
            <label class="control-label col-sm-3">
                <?php _e("Error text", osc_current_web_theme()); ?>
            </label>
            <div class="col-sm-9">
                <div class="input-group colorpicker-component js-colorpicker width-md">
                    <input class="form-control" type="text" name="design[custom][alert_danger][variables][alert_danger_color]" value="<?php echo mtk_field(array("design", "custom", "alert_danger", "variables"), "alert_danger_color"); ?>" />
                    <span class="input-group-addon bg-light"><i></i></span>
                </div>
                <p class="help-block"><?php _e("Choose some color that has a good contrast with the color above.", osc_current_web_theme()); ?></p>
            </div>
        </div>
    </div>
</div>
