<?php

/*
 * ==========================================================================
 *  INIT
 * ==========================================================================
 */

Madhouse_ThemeKitchen_Package::init();

if (! OC_ADMIN) {
    /*
	 * ==========================================================================
	 *  HOOKS & FILTERS
	 * ==========================================================================
	 */

    // Disable follow rules if madhouse seo is enabled
    if (!osc_plugin_is_enabled("madhouse_seo/index.php")) {
        osc_add_hook("header", "mkt_follow_rules");
    }

    osc_add_hook("header", function () {
        $socialModule = new Madhouse_ThemeKitchen_Modules_SocialModule;
        $socialModule->getMeta();
    });

    osc_add_hook("init", function () {
        if (osc_is_home_page()) {
            mtk_default_item_style(('i_item_default_style'));
        }
    });

    osc_add_hook("before_html", "mtk_widget_flash_messages");
    osc_add_hook("init", "mtk_user_dashboard_redirect");

    osc_add_hook("after_search", function () {
        mtk_default_item_style('i_search_item_default_style');
    });

    osc_add_hook("init", function () {
        if (osc_is_public_profile()) {
            mtk_default_item_style('i_user_item_default_style');


            if (mtk_field('layout', 'i_user_all_items')) {
                // display all items in public profile (deactivate pagination)
                Params::setParam('itemsPerPage', 'all');
            }
        }
    });

    osc_add_hook("init", function () {
        // export user in dashboard, paswword chnage, email change and change username page
        if (osc_is_user_dashboard() || osc_is_change_password_page() || osc_is_change_email_page() || osc_is_current_page("user", "change_username")) {
            if (! View::newInstance()->_exists("user") || ! View::newInstance()->_get("user")) :
                View::newInstance()->_exportVariableToView('user', User::newInstance()->findByPrimaryKey(osc_logged_user_id()));
            endif;
        }
    });

    osc_add_hook('search_conditions', function ($params) {
      if(isset($params['type']) && $params['type'] != '' && $params['type'] != null) {
        Search::newInstance()->addJoinTable(
            'pk_i_id',
            User::newInstance()->getTableName() . ' mkt_user',
            Item::newInstance()->getTableName() . '.fk_i_user_id = mkt_user.pk_i_id',
            'LEFT OUTER'
        );

        if(Params::getParam('type') == 'professional') {
          Search::newInstance()->addConditions("mkt_user.b_company = 1");
        } elseif (Params::getParam('type') == 'personal') {
          Search::newInstance()->addConditions("coalesce(mkt_user.b_company, 0) <> 1");
        }
      }
    });

    function mtk_search_keyword_wildcard($params) {

        if (@$params['sPattern']) {
            $mSearch =  Search::newInstance();
            $query_elements = (array) json_decode($mSearch->toJson());

            $query_elements['sPattern'] = str_replace(' ', '* ', $query_elements['sPattern']) . '*';

            $mSearch->setJsonAlert($query_elements);
        }
    }

    osc_add_hook('search_conditions', 'mtk_search_keyword_wildcard', 10);

    //
    osc_add_hook("feed_api", "Madhouse_ThemeKitchen_Services_AjaxSearchService::getFeed");


    osc_add_hook("ajax_search_form", "Madhouse_ThemeKitchen_Services_AjaxSearchService::searchFilters");

} else {
    /*
	 * ==========================================================================
	 *  REGISTER & ENQUEUE
	 * ==========================================================================
	 */

    osc_add_hook("init_admin", function () {
        if (defined('DEMO') && DEMO == true && Params::getParam('page') == 'appearance' && Params::getParam('action') == '') {
            osc_add_flash_warning_message(__("Sorry, you can't change the theme on a demo website."), 'admin');
            osc_redirect_to(osc_admin_base_url());
        }
        $pages = array('tools', 'settings', 'users', 'items', 'market', 'pages', 'categories', 'media', 'cfields', 'stats', 'emails', 'languages', 'admins');
        if (defined('DEMO') && DEMO == true && in_array(Params::getParam('page'), $pages)) {
            osc_add_flash_warning_message(__("Sorry, you can't do this on a demo website."), 'admin');
            osc_redirect_to(osc_admin_base_url());
        }
    });

    osc_add_hook("login_admin_form", function () {
        if (defined('DEMO') && DEMO == true) {
            echo '<div>
                <p>
                    <label class="forgetmenot" style="padding-bottom:10px; font-size: 1.4em">Login: admin</label>
                </p>
                <p>
                    <label class="forgetmenot" style="padding-bottom:10px; font-size: 1.4em">Password: admin</label>
                </p></div>';
        }
    });

    /**
     * Register scripts.
     *
     */
    osc_register_script(
        "themekitchen_admin",
        Madhouse_ThemeKitchen_Package::getURL("assets/js/dist/admin" . (OSC_DEBUG ? "" : ".min") . ".js"),
        "jquery"
    );

    /**
     * Enqueue scripts & styles on themekitchen page only.
     *
     */
    if (mtk_is_settings_page()) {
        osc_register_script(
            "jquery",
            Madhouse_ThemeKitchen_Package::getURL("vendor/bower_components/jquery/dist/jquery.min.js")
        );

        osc_enqueue_script("themekitchen_admin");

        osc_enqueue_style("font-rubik-admin", "https://fonts.googleapis.com/css?family=Rubik:400,500,700,400italic,500italic");
        osc_enqueue_style(
            "themekitchen_admin",
            Madhouse_ThemeKitchen_Package::getURL("assets/css/dist/admin.min.css")
        );
    }

    /*
	 * ==========================================================================
	 *  ROUTES
	 * ==========================================================================
	 */
    osc_add_hook("init_admin", function () {
        if (mtk_is_settings_page() || mtk_is_settings_post_page() || mtk_settings_delete_resource_post_page()) {
            // Just launch the admin controller.
            $c = new Madhouse_ThemeKitchen_Controllers_Admin();
            $c->doModel();
        }
    });

    /*
	 * ==========================================================================
	 *  ADMIN MENU
	 * ==========================================================================
	 */

    osc_add_admin_submenu_divider("appearance", Madhouse_ThemeKitchen_Package::getThemeSlug(), "themekitchen");
    osc_admin_menu_appearance(
        __("Plugins", "themekitchen"),
        mtk_settings_url("plugin"),
        "themekitchen-plugins"
    );

    osc_admin_menu_appearance(
        __("General", "themekitchen"),
        mtk_settings_url("general"),
        "themekitchen-general"
    );

    osc_admin_menu_appearance(
        __("Layout", "themekitchen"),
        mtk_settings_url("layout"),
        "themekitchen-layout"
    );

    osc_admin_menu_appearance(
        __("Widgets", "themekitchen"),
        mtk_settings_url("widgets"),
        "themekitchen-widgets"
    );

    osc_admin_menu_appearance(
        __("Slider", "themekitchen"),
        mtk_settings_url("slider"),
        "themekitchen-slider"
    );

    osc_admin_menu_appearance(
        __("Design", "themekitchen"),
        mtk_settings_url("design"),
        "themekitchen-design"
    );

    osc_admin_menu_appearance(
        __("Categories", "themekitchen"),
        mtk_settings_url("categories"),
        "themekitchen-categories"
    );

    osc_admin_menu_appearance(
        __("Social Networks", "themekitchen"),
        mtk_settings_url("social_networks"),
        "themekitchen-social"
    );

    osc_admin_menu_appearance(
        __("Backup", "themekitchen"),
        mtk_settings_url("backup"),
        "themekitchen-backup"
    );

    /*
	 * ==========================================================================
	 *  HOOKS & FILTERS
	 * ==========================================================================
	 */

    osc_add_filter("custom_appearance_title", function ($string) {
        return $string . " – " . ucwords(osc_current_web_theme());
    });

    if (mtk_is_settings_page()) {
        // Add a .row-offset to wrapping <div /> element.
        osc_add_filter("render-wrapper", function ($string) {
            return "row-offset";
        });
    }
}
