module.exports = function(grunt) {

  // Import dependencies.
  grunt.loadNpmTasks('grunt-sass');
  grunt.loadNpmTasks('grunt-contrib-cssmin');
  grunt.loadNpmTasks('grunt-contrib-concat');
  grunt.loadNpmTasks('grunt-contrib-uglify');
  grunt.loadNpmTasks('grunt-contrib-watch');

  var jsSrc = [
    'vendor/bower_components/bootstrap-sass/assets/javascripts/bootstrap.min.js',
    'vendor/bower_components/jquery-ui/ui/core.js',
    'vendor/bower_components/jquery-ui/ui/widget.js',
    'vendor/bower_components/jquery-ui/ui/mouse.js',
    'vendor/bower_components/jquery-ui/ui/sortable.js',
    'vendor/bower_components/jquery-ui/ui/draggable.js',
    'vendor/bower_components/codemirror/lib/codemirror.js',
    'vendor/bower_components/codemirror/mode/xml/xml.js',
    'vendor/bower_components/codemirror/mode/htmlmixed/htmlmixed.js',
    'vendor/bower_components/codemirror/mode/htmlembedded/htmlembedded.js',
    'vendor/bower_components/codemirror/mode/javascript/javascript.js',
    'vendor/bower_components/codemirror/mode/css/css.js',
    'vendor/bower_components/codemirror/mode/sql/sql.js',
    'vendor/bower_components/jquery-sheeper/dist/jquery.sheeper.js',
    'vendor/bower_components/bootstrap-switch/dist/js/bootstrap-switch.min.js',
    'vendor/bower_components/bootstrap-colorpicker/dist/js/bootstrap-colorpicker.min.js',
    'vendor/bower_components/jquery.serializeJSON/jquery.serializejson.js',
    'assets/js/admin.js'
  ];
  var jsDist = 'assets/js/dist/admin.js';
  var jsDistMin = 'assets/js/dist/admin.min.js';

  // Configuration de Grunt
  grunt.initConfig({
    sass: {
      dev: {
        options: {
          includePaths: [
            './vendor/bower_components/'
          ],
          sourceMap: true,
          style: 'expanded',
        },
        files: [{
          "expand": true,
          "cwd": "assets/css/",
          "src": ["admin.scss"],
          "dest": "assets/css/dist/",
          "ext": ".css"
        }]
      }
    },
    cssmin: {
      options: {
        rebase: true
      },
      minify: {
        files: {
          'assets/css/dist/admin.min.css': [
            'vendor/bower_components/codemirror/lib/codemirror.css',
            'vendor/bower_components/codemirror/theme/pastel-on-dark.css',
            'vendor/bower_components/ionicons/css/ionicons.min.css',
            'vendor/bower_components/bootstrap-switch/dist/css/bootstrap3/bootstrap-switch.min.css',
            'assets/css/dist/admin.css',
            'vendor/bower_components/bootstrap-colorpicker/dist/css/bootstrap-colorpicker.css'
          ],
        }
      }
    },
    concat: {
      options: {
        separator: ';'
      },
      compile: { // On renomme vu qu'on n'a pas de mode dev/dist. Dist étant une autre tâche : uglify
        src: jsSrc, // Vu qu'on doit l'utiliser deux fois, autant en faire une variable.
        dest: jsDist // Il existe des hacks plus intéressants mais ce n'est pas le sujet du post.
      }
    },
    uglify: {
      options: {
          compress: true,
          mangle: true
      },
      compile: {
        src: '<%= concat.compile.dest %>',
        dest: jsDistMin
      }
    },
    watch: {
      styles: {
        files: 'assets/css/admin.scss',
        tasks: ['styles:dev']
      },
      scripts: {
        files: 'assets/js/*.js',
        tasks: ['scripts:dev']
      }
    }
  });

  grunt.registerTask('default', ['dev', 'watch']);
  grunt.registerTask('dev', ['styles:dev', 'scripts:dev']);
  grunt.registerTask('styles:dev', ['sass:dev', 'cssmin']);
  grunt.registerTask('scripts:dev', ['concat:compile', 'uglify:compile']);
};
