<?php osc_run_hook("mcf_register_before"); ?>

<?php osc_run_hook('mdh_facebook_button_register'); // Facebook register button ?>

<form class="form-vertical js-register-form js-item-form" action="<?php echo osc_base_url(true); ?>"
method="post" enctype="multipart/form-data">
    <?php
        mcf_input_hidden("page", "register");
        mcf_input_hidden("action", "register_post");

        $data = array(
            "data-rule-required"=>"true",
            "data-msg-required"=>__("This field is required", osc_current_web_theme())
        );
        mcf_input_generic("text", 's_name', "", __("Name", osc_current_web_theme()), "", "", $data);

        $data = array(
            "data-rule-required"=>"true",
            "data-msg-required"=>__("This field is required", osc_current_web_theme()),
            "data-rule-email"=>"true",
            "data-msg-email"=>__("The input is not a valid email address", osc_current_web_theme())
        );
        mcf_input_generic("text", 's_email', "", __("E-mail", osc_current_web_theme()), "", "", $data);

        $data = array(
            "data-rule-required"=>"true",
            "data-msg-required"=>__("This field is required", osc_current_web_theme()),
            "data-rule-minlength"=>"5",
            "data-msg-minlength"=>__("The password must be more than {0} characters", osc_current_web_theme())
        );
        mcf_input_generic("password", 's_password', "", __("Password", osc_current_web_theme()), "", "", $data);

        $data = array_merge($data, array(
            "data-rule-equalto"=>"#s_password",
            "data-msg-equalto"=>__("The password and its confirm are not the same", osc_current_web_theme())
        ));
        mcf_input_generic("password", 's_password2', "", __("Repeat password", osc_current_web_theme()), "", "", $data);

        if (mtk_field("$.layout","i_register_user_type")) {
            $value=array();
            $value['current'] = osc_user_is_company();
            $value['choices'] = array(
                        array( 'i_value' => '0', 's_text' => (__('User', osc_current_web_theme())) )
                        ,array( 'i_value' => '1', 's_text' => (__('Company', osc_current_web_theme())) )
                    );
            $value['key_value'] = 'i_value';
            $value['key_name'] = 's_text';
            mcf_input_generic("select", 'b_company', $value, __("User type", osc_current_web_theme()), "", "");
        }

        if (mtk_field("$.layout","i_register_user_phone")) {
            mcf_input_generic("text", 's_phone_mobile', osc_user_phone_mobile(), __("Cell phone", osc_current_web_theme()), "", "");
        }

        if (mtk_field("$.layout","i_register_user_website")) {
            mcf_input_generic("text", 's_website', osc_user_website(), __("Website", osc_current_web_theme()), "", "");
        }

        View::newInstance()->_exportVariableToView("location_style", mtk_field("$.layout","i_register_user_location_style"));

        if (mtk_field("$.layout","i_register_user_country")) {
            osc_current_web_theme_path('parts/location/country-form.php');
        }

        if (mtk_field("$.layout","i_register_user_region")) {
            osc_current_web_theme_path('parts/location/region-form.php');
        }


        if (mtk_field("$.layout","i_register_user_city")) {
            osc_current_web_theme_path('parts/location/city-form.php');
        }

        osc_run_hook('user_register_form');

        mcf_show_recaptcha();

        mcf_button(__('Sign up', osc_current_web_theme()), "btn-block btn-primary", "");
    ?>
</form>
<?php osc_run_hook("mcf_register_after"); ?>