<div class="modal-header">
    <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
    <h4 class="modal-title m-b-0" id="modalContact">
        <?php if (osc_item_is_premium()): ?>
            <span class="text-sm label label-premium"><?php _e("Premium listing", osc_current_web_theme()) ?></span>
        <?php endif; ?>
        <?php echo osc_item_title() ?>
    </h4>
</div>
<div class="p-md">
    <div class="row">
    	<div class="col-sm-8">
    		<?php if (osc_count_item_resources() > 0) : ?>
                <div class="m-b-sm item-carousel">
                    <?php if (mtk_field("layout", "i_item_pictures_mode") == 1) : ?>
                        <?php osc_current_web_theme_path('parts/item/lightbox.php'); ?>
                    <?php else : ?>
                        <?php osc_current_web_theme_path('parts/item/carousel.php'); ?>
                    <?php endif; ?>
                </div>
            <?php endif; ?>
            <?php osc_current_web_theme_path('parts/item/details.php'); ?>
    	</div>
    	<div class="col-sm-4">
    		<?php osc_current_web_theme_path('parts/blocks/item_sidebar/item_sidebar-user.php'); ?>
            <div class="m-b-md">
                <a href="<?php echo osc_item_send_friend_url(); ?>" rel="nofollow" class="btn btn-secondary btn-block">
                    <i class="ion-paper-airplane"></i>&nbsp;<?php _e('Send to a friend', osc_current_web_theme()); ?>
                </a>
            </div>
             <?php
            $location = array();
            if (osc_item_city_area() !== '') {
                $location[] = osc_item_city_area();
            }
            if (osc_item_city() !== '') {
                $location[] = osc_item_city();
            }
            if (osc_item_region() !== '') {
                $location[] = osc_item_region();
            }
            if (osc_item_country() !== '') {
                $location[] = osc_item_country();
            }
            ?>
            <?php if (count($location) > 0) : ?>
                <div class="card card-flat">
                    <div class="card-header">
                        <?php _e("Listing location", osc_current_web_theme()) ?>
                    </div>
                    <div class="card-block text-sm">
                        <span class=""><i class="ion-location m-r-sm"></i><?php echo implode(', ', $location); ?></span>
                    </div>
                    <?php if (osc_plugin_is_enabled("google_maps/index.php") && osc_item_latitude() != "" && osc_item_longitude() != "") : ?>
                        <?php $item = osc_item(); ?>
                        <?php require osc_plugin_path('') . "google_maps/map.php"; ?>
                    <?php endif; ?>
                </div>
            <?php endif; ?>
    	</div>
    </div>
</div>
<div class="modal-footer modal-footer-center">
    <a class="btn btn-primary" href="<?php echo osc_item_url() ?>"><?php _e("View more of this listing", osc_current_web_theme()) ?></a>
</div>