<?php if (osc_images_enabled_at_items()) : ?>
    <?php
    if (osc_count_item_resources() > 0) :
        $i = 0;
    ?>
        <div class="carousel-container clearfix">
            <div class="overlay-wrapper">
                <div class="slider-for m-b-md">
                    <?php while (osc_has_item_resources()) : ?>
                        <div class="item item-resource">
                            <img class="img-responsive" data-src="<?php echo osc_resource_url(); ?>" data-lazy="<?php echo osc_resource_url(); ?>" />
                            <a class="fancy-resource hidden" href="<?php echo osc_resource_url(); ?>">
                                <i class="ion-plus"></i>
                            </a>
                        </div>
                    <?php endwhile; ?>
                </div>
                <?php if (!Params::existParam('quick-view')): ?>
                    <a class="overlay bg-dark lter text-white p-y-xs p-x-sm r-sm overlay-bottom overlay-right js-slider-fancybox" href="#">
                        <i class="ion-plus"></i>
                    </a>
                <?php endif ?>
                <div class="overlay bg-dark lter text-white p-y-xs p-x-sm r-sm overlay-bottom overlay-left ">
                    <i class="ion-camera"></i>&nbsp;<span class="slider-for-pagination">1 / <?php echo osc_count_item_resources() ?></span>
                </div>
            </div>
            <?php if (!Params::existParam('quick-view')): ?>
                <!-- thumb navigation carousel items -->
                <div class="js-slider-nav">
                    <?php osc_reset_resources(); ?>
                    <?php while (osc_has_item_resources()) : ?>
                        <div>
                            <div class="item item-resource">
                                <img class="img-responsive" data-lazy="<?php echo osc_resource_thumbnail_url(); ?>"/>
                            </div>
                        </div>
                    <?php endwhile; ?>
                </div>
            <?php endif ?>
        </div>
    <?php else: ?>
        <div class="p-y-lg text-center">
            <span class="text-muted"><?php _e("No picture for this listing", osc_current_web_theme()) ?></span>
        </div>
    <?php endif; ?>
<?php endif; ?>