<?php
/*
 * Block Name: Main categories grid with icon
 * Block Slug: homepage_categories_icon
 * Description: Blablabla.
 * Widget Hooks: homepage
 */ ?>

<div class="section section-grid categories-grid-icon">
    <div class="container">
        <div class="row">
            <div class="col-sm-10 col-sm-offset-1">
                <div class="row">
                    <?php osc_goto_first_category(); ?>
                    <?php while (osc_has_categories()) : ?>
                        <?php $categoryName = osc_category_name(); ?>
                        <?php $categoryUrl = osc_search_category_url(); ?>
                        <div class="col-sm-3 col-xs-6">
                            <a class="link-reset" href="<?php echo $categoryUrl ?>">
                                <div class="card card-flat text-center">
                                    <?php $category = "$.categories[" . osc_category_id() . "]"; ?>
                                    <div class="card-block">
                                            <?php if (mtk_field($category, "s_icon") != "") : ?>
                                                <div class="m-b-sm">
                                                    <span style="<?php echo (mtk_field($category, "s_color") != "") ? "color: " . mtk_field($category, "s_color") : ""; ?>" class="text-3x <?php echo (mtk_field($category, "s_color") == "") ? "text-primary" : ""; ?>">
                                                        <i class="<?php echo mtk_field($category, "s_icon") ?>"></i>
                                                    </span>
                                                </div>
                                            <?php endif; ?>
                                        <h3 class="h5 card-title">
                                            <span class="text-ellipsis"><?php echo $categoryName; ?></span>
                                        </h3>
                                        <p class="card-subtitle text-muted categories-grid-items">
                                            <?php printf(__("%d listings", osc_current_web_theme()), osc_category_total_items()); ?>
                                        </p>
                                    </div>
                                </div>
                            </a>
                        </div>
                    <?php endwhile; ?>
                </div>
            </div>
        </div>
    </div>
</div>