<?php
/*
 * Block Name: Homepage Categories Grid
 * Block Slug: homepage_categories_grid
 * Description: Blablabla.
 * Widget Hooks: homepage
 */ ?>

<div class="section">
    <div class="container">
        <h2 class="title-special"><?php _e("All categories", osc_current_web_theme()); ?></h2>
        <div class="row js-masonry">
        <?php osc_goto_first_category(); ?>
        <?php while (osc_has_categories()) : ?>
            <?php
            $categoryName = osc_category_name();
            $categoryUrl = osc_search_category_url();
            $maxItem = 5 + 1;
            ?>
            <div class="col-xs-12 col-sm-6 col-md-3 grid-item">
                <div class="panel">
                    <?php $widget = "$.categories[" . osc_category_id() . "]"; ?>
                    <?php if (mtk_field($widget, "s_icon") != "" || mtk_resource_url($widget, "s_image") != "") : ?>
                        <div class="panel-header">
                            <?php if (mtk_resource_url($widget, "s_image") != "") : ?>
                                <div class="row-space-2 text-center">
                                <img class="img-responsive" src="<?php echo mtk_resource_url($widget, "s_image"); ?>">
                                </div>
                            <?php endif; ?>
                        </div>
                    <?php endif; ?>
                    <div class="space-in bg-white dker">
                        <h3 class="text-ellipsis h4 m-b-0">
                            <?php if (mtk_field($widget, "s_icon") != "") : ?>
                                <i class="text-md <?php echo mtk_field($widget, "s_icon"); ?>"></i>
                            <?php endif; ?>
                            <?php echo osc_category_name(); ?>
                        </h3>
                    </div>
                    <ul class="list-group">
                        <?php $i = 0 ?>
                        <?php while (osc_has_subcategories()) : ?>
                            <?php if ($i <= $maxItem) : ?>
                                <?php $widget = "$.categories[" . osc_category_id() ."]"; ?>
                                <li class="list-group-item text-ellipsis ">
                                <span class="badge badge-primary"><?php echo osc_category_total_items(); ?></span>
                                <a class="" href="<?php echo osc_search_category_url(); ?>">
                                    <?php if (mtk_field($widget, "s_icon") != "") : ?>
                                        <i class="text-md <?php echo mtk_field($widget, "s_icon"); ?>"></i>
                                    <?php endif; ?>
                                    <?php echo osc_category_name(); ?>
                                </a>
                                </li>
                            <?php endif; ?>
                            <?php $i++; ?>
                        <?php endwhile; ?>
                        <li class="list-group-item text-ellipsis"><a href="<?php echo $categoryUrl; ?>"><?php _e("See More", osc_current_web_theme()); ?></a></li>
                    </ul>
                </div>
            </div>
        <?php endwhile; ?>
        </div>
    </div>
</div>