<?php
/*
 * Block Name: Categories Highlighted
 * Block Slug: categories_highlighted
 * Description: Blablabla.
 * Widget Hooks: homepage,404,item,item_contact,item_send_friend,user_dashboard
 */ ?>

<?php $categoriesHighlighted = mtk_field("$.categories[?(@.b_highlighted=='1')].pk_i_id"); ?>
<?php if (count($categoriesHighlighted) > 0) : ?>
<div class="section section-grid">
    <div class="container">
        <?php if (count($categoriesHighlighted) === 1) : ?>
            <?php $colsize = "col-xs-12 col-sm-6 col-sm-offset-3"; ?>
        <?php elseif (count($categoriesHighlighted) === 2) : ?>
            <?php $colsize = "col-xs-12 col-sm-6"; ?>
        <?php else : ?>
            <?php $colsize = "col-xs-12 col-sm-4"; ?>
        <?php endif; ?>

        <?php $previous_categories = osc_get_categories(); ?>
        <?php osc_export_categories(Category::newInstance()->listAll()); ?>
        <?php osc_goto_first_category(); ?>
        <div class="row js-masonry">
            <?php while (osc_has_categories()) : ?>
                <?php if (in_array(osc_category_id(), $categoriesHighlighted)) : ?>
                    <div class="<?php echo $colsize; ?> grid-item">
                        <div class="card card-flat">
                            <div class="card-block">
                                <h3 class="card-title">
                                    <?php echo osc_category_name(); ?>
                                </h3>
                                <p class="card-subtitle text-muted">
                                    <?php printf(__("%d listings", osc_current_web_theme()), osc_category_total_items()); ?>
                                </p>
                            </div>
                            <?php if (mtk_resource_url(array("categories", osc_category_id()), "s_image")) : ?>
                                <img class="card-img" src="<?php echo mtk_resource_url(array("categories", osc_category_id()), "s_image"); ?>" />
                            <?php endif; ?>
                            <div class="card-block">
                                <?php if (osc_category_description()) : ?>
                                    <p class="card-text">
                                        <?php echo osc_highlight(osc_category_description(), 140); ?>
                                    </p>
                                <?php endif; ?>
                                <a class="btn btn-primary btn-outline" href="<?php echo osc_search_category_url(); ?>">
                                    <?php _e("See more", osc_current_web_theme()) ?></a>
                            </div>
                        </div>
                    </div>
                <?php endif; ?>
            <?php endwhile; ?>
        </div>
        <?php osc_export_categories($previous_categories); ?>
    </div>
</div>
<?php endif; ?>
