$(document).ready(function() {
    if ($(".messenger-widget-text").length && $(".messenger-widget").length) {
         $.ajax({
            type: "GET",
            url: $(".messenger-widget-text").data("messenger-url"),
            data: {
            "do": "widget"
            },
            dataType: "json",
            success: function(response, text, jqXHR) {
                var $this = $(".messenger-widget-text");

                // Inserts a small stamp to notify new messages.
                if (response.nbUnread > 0) {
                  $this.html('<span class="badge badge-danger">' + response.nbUnread + '</span>');
                }

                // Get messenger widget container
                $messengerWidget = $(".messenger-widget");

                // Load twig template
                var template = twig({
                    id: "list", // id is optional, but useful for referencing the template later
                    href: $messengerWidget.data("template"),
                    async: false
                });

                // Render twig template
                var output = twig({ref:"list"}).render({
                    threads: response.threads,
                    madhouse_avatar: {
                        no_photo: $messengerWidget.data("madhouse-avatar-no-photo"),
                        enabled: $messengerWidget.data("madhouse-avatar-enabled")
                    },
                    content: {
                      no_messages: $(".messenger-widget-text").data("content-no-messages")
                    },
                    logged_user_id: $messengerWidget.data("logged-user-id")
                });

                // fix
                output = output.replace(/[\u200B]/g, '');

                // Remove spinner
                $messengerWidget.find(".spinner-wrapper").remove();

                // Append results
                $messengerWidget.append(output);
            }
      });
    }

    $(document).ready(function () {
        $('#js-listing-user-filter').bind('change', function(e) {
            var url = $(this).val(); // get selected value
            if (url) { // require a URL
              window.location = url; // redirect
            }
            return false;
        });
    });
});