$(document).ready(function() {
    Dropzone.autoDiscover = false;
    var _clickable = ".clickable",
        _previewsContainer = ".previews",
        _paramName = "qqfile",
        _fileDropzone = "#file-dropzone",
        _previewNode = "#template",
        _dzRemove = '.dz-remove';


    var $fileDropzone = $(_fileDropzone);
    if ($fileDropzone.length > 0) {
        // Get the template HTML and remove it from the doumenthe template HTML and remove it from the doument
        var previewNode = document.querySelector(_previewNode);
        previewNode.id = "";
        previewTemplate = previewNode.parentNode.innerHTML;
        previewNode.parentNode.removeChild(previewNode);



        var option = {
            url: $fileDropzone.data('url'),
            autoDiscover: false,
            maxFilesize: $fileDropzone.data('max-files-size'),
            acceptedFiles: "image/*",
            //acceptedFiles: "image/png,image/gif,image/jpg,image/jpeg",
            // maxFiles: $fileDropzone.data('max-files'),
            //addRemoveLinks: true,
            paramName: _paramName,
            maxThumbnailFilesize: 5,
            previewsContainer: _previewsContainer, // Define the container to display the previews
            clickable: _clickable, // Define the element that should be used as click trigger to select files.
            previewTemplate: previewTemplate,
            thumbnailWidth: $fileDropzone.data('thumbnail-width'),
            thumbnailHeight: $fileDropzone.data('thumbnail-height'),
            dictDefaultMessage: $fileDropzone.data('dict-default-message'),
            dictFallbackMessage: $fileDropzone.data('dict-fallback-message'),
            dictFallbackText: $fileDropzone.data('dict-fallback-text'),
            dictFileTooBig: $fileDropzone.data('dict-file-too-big'),
            dictInvalidFileType: $fileDropzone.data('dict-invalid-file-type'),
            dictResponseError: $fileDropzone.data('dict-response-error'),
            dictCancelUpload: $fileDropzone.data('dict-cancel-upload'),
            dictCancelUploadConfirmation: $fileDropzone.data('dict-cancel-upload-confirmation'),
            dictRemoveFile: $fileDropzone.data('dict-remove-file'),
            dictRemoveFileConfirmation: $fileDropzone.data('dict-remove-file-confirmation'),
            dictMaxFilesExceeded: $fileDropzone.data('dict-max-files-exceeded')
        };

        if ("0" != $fileDropzone.data('max-files')) {
            $.extend(option, {maxFiles: $fileDropzone.data('max-files')});
        }

        if (!$fileDropzone.data('edit')) {
            $( ".previews" ).sortable(
                {zIndex: 1000}
            );
        }


        var myDropzone = new Dropzone(document.body, option);

        myDropzone.on('init', function() {
            var myDropzone = this;
            var submitButton = document.querySelector("#dzsubmit");
            submitButton.addEventListener("click", function () {
                myDropzone.processQueue();
            });

        });

        myDropzone.on('error', function(file, response) {
            try {
                response = $.parseJSON(response);
            } catch(err) {
                response = response;
            }
            // (assuming your response object has an errorMessage property...)
            var errorMessage = response.error;
            $(file.previewElement).find('.dz-error-message').text(errorMessage);
        });


        myDropzone.on('success', function(file, json) {
            try {
                json = $.parseJSON(json);
            } catch(err) {
                json = json;
            }

            if (json.success) {
                $previewTemplate = $(file.previewTemplate);
                $previewTemplate.append('<input type="hidden" name="ajax_photos[]" value="'+json.uploadName+'"></input>');
                $previewTemplate.find(_dzRemove).data("name", file.name);
            } else {
                // below is from the source code too
                var node, _i, _len, _ref, _results;
                var message = json.error // modify it to your error message
                file.previewElement.classList.add("dz-error");
                file.previewElement.classList.remove("dz-success");
                _ref = file.previewElement.querySelectorAll("[data-dz-errormessage]");
                _results = [];
                for (_i = 0, _len = _ref.length; _i < _len; _i++) {
                  node = _ref[_i];
                  _results.push(node.textContent = message);
                }
                return _results;
            }
        });

        myDropzone.on('removedfile', function(file) {
            if (file.accepted) {
                var $dzRemove = $(file.previewTemplate).find(_dzRemove);
                if ($dzRemove.data("secret") !== undefined) {
                    var data = {
                        page: "ajax",
                        action: "delete_image",
                        id: $dzRemove.data("id"),
                        item: $dzRemove.data("item"),
                        code: $dzRemove.data("secret"),
                        secret: $fileDropzone.data('item-secret')
                    };
                } else {
                    var data = {
                        page: "ajax",
                        action: "delete_ajax_upload",
                        qquuid: $dzRemove.data("name")
                    };
                }
                $.ajax({
                    method: 'POST',
                    url: $fileDropzone.data('base-url'),
                    data: data
                });
            }
            if (!myDropzone.files || !myDropzone.files.length) {
                $(".thumbnail-label").addClass("hidden");
            }
        });

        myDropzone.on('sending', function(file, xhr, formData) {
            formData.append("qquuid", file.name);
        });

        myDropzone.on('addedfile', function(file) {
            /* Maybe display some more file information on your page */
            $previewTemplate = $(file.previewTemplate);
            if (file.secret !== undefined) {
                $previewTemplate.find(_dzRemove).data("secret", file.secret).data("id", file.id).data("item", file.itemId);
            } else {
                $previewTemplate.find(_dzRemove).data("name", file.name);
            }


            $(".thumbnail-label").removeClass("hidden");

        });

        _resources = $fileDropzone.data('resources');
        $.each(_resources, function(key, value) {

            if(typeof value === 'object') {
                var mockFile = {
                name: value['pk_i_id'],
                size: 12345,
                secret: value['s_name'],
                id : value['pk_i_id'],
                itemId : value['fk_i_item_id'],
                accepted: true
                };
                var thumbnail = $fileDropzone.data('base-url') + value['s_path'] + value['pk_i_id'] + '_thumbnail.' + value['s_extension'];

            } else {
                var mockFile = {
                name: value,
                size: 12345,
                accepted: true
                };

                var thumbnail = $fileDropzone.data('base-url') + "oc-content/uploads/temp/"+value;
            }

            mockFile.kind = "file";
            // Call the default addedfile event handler
            myDropzone.emit("addedfile", mockFile);
            myDropzone.files.push(mockFile);
            myDropzone.emit("thumbnail", mockFile, thumbnail);
            // Make sure that there is no progress bar, etc...
            myDropzone.emit("complete", mockFile);
            if(typeof value !== 'object') {
                myDropzone.emit("success", mockFile, {success:true, uploadName:value });
            }
        });
    }
});