$(document).ready(function(){

    $('[data-toggle="text-counter"]').each(function (value) {
        $(this).textcounter({
                max                      : parseInt($(this).data("rule-maxlength")),
                countContainerClass      : "pull-right",
                textCountClass           : "help-block",
                countDown                : true,
                displayErrorText         : false,
                stopInputAtMaximum       : false,
                countSpaces              : true,
                countDownText            : ""
            }
        );
    });

    // catPriceEnabled create with function plugin_post_item() of the core UGLY !!!
    function togglePrice() {
        var cat_id = $("#catId").val();
        if(cat_id != '') {
            if(catPriceEnabled[cat_id] == 1) {
                $(".js-price").show();
            } else {
                $(".js-price").closest("div").hide();
                $('#js-price-input').val('') ;
            }
        }
    }

    if ($("#catId").length) {
        // Init
        togglePrice();

        $("#catId").change(function(){
            togglePrice();
        });
    }


    $( document ).ajaxComplete(function( event, xhr, settings ) {
        if (
            settings.data != undefined &&
            settings.data.indexOf("page=ajax&action=runhook") >= 0
        ) {
            if (xhr.responseText != '<div class="row"></div>') {
                $(".js-plugin-hook-wrapper").addClass("card card-block");
            } else {
                $(".js-plugin-hook-wrapper").removeClass("card card-block");
            }
        }
    });

    var $form       = $('.js-item-form'),
    baseUrl         = $('body').data('base-url'),
    textCountry     = _("Select a country..."),
    textRegion      = _("Select a region..."),
    textCity        = _("Select a city..."),
    textNoResults   = _("No results"),
    displayLocation = $form.data('display-location');


    var $country = $('#country'),
    $countryId   = $('#countryId'),
    $region      = $('#region'),
    $regionId    = $('#regionId'),
    $city        = $('#city'),
    $cityId      = $('#cityId');

    if ($country.length) {
        $country.attr( "autocomplete", "off" );
    }
    $region.attr( "autocomplete", "off" );
    $city.attr( "autocomplete", "off" );


    $countryId.change(function(){
        $(this).closest('form').find('#regionId').val('');
        $(this).closest('form').find('#region').val('');
        $(this).closest('form').find('#cityId').val('');
        $(this).closest('form').find('#city').val('');
    });

    $(document).on('keyup.autocomplete', '#country', function (event){
        if ( event.which == 13 ) {
            return
        }

        var $form      = $(this).closest('form'),
            $city      = $form.find('#city'),
            $cityId    = $form.find('#cityId'),
            $region    = $form.find('#region'),
            $regionId  = $form.find('#regionId'),
            $country   = $form.find('#country'),
            $countryId = $form.find('#countryId');

        $(this).autocomplete({
            source: baseUrl + "?page=ajax&action=location_countries",
            minLength: 0,
            search  : function(){
                $(this).parent().addClass("loader");
            },
            response    : function(){
                $countryId.val("");
                $(this).parent().removeClass("loader");
            },
            select: function( event, ui ) {
                $countryId.val(ui.item.id);
                $region.val('');
                $regionId.val('');
                $city.val('');
                $cityId.val('');
            }
        });
    });

    $(document).on('keyup.autocomplete', '#region', function(event){
        if ( event.which == 13 ) {
            return
        }

        var $form      = $(this).closest('form'),
            $city      = $form.find('#city'),
            $cityId    = $form.find('#cityId'),
            $region    = $form.find('#region'),
            $regionId  = $form.find('#regionId'),
            $country   = $form.find('#country'),
            $countryId = $form.find('#countryId');


        if($countryId.val()!='' && $countryId.val()!=undefined) {
            var country = $countryId.val();
        } else if ($country.val() != undefined) {
            var country = $country.val();
        } else {
            var country = '';
        }

        $( this ).autocomplete({
            source: baseUrl + "?page=ajax&action=location_regions&country=" + country,
            minLength: 2,
            search  : function(){
                $(this).parent().addClass("loader");
            },
            response    : function(){
                $regionId.val('');
                $(this).parent().removeClass("loader");
            },
            select: function( event, ui ) {
                $city.val('');
                $cityId.val('');
                $regionId.val(ui.item.id);
            }
        });
    });

    $(document).on('keyup.autocomplete', '#city', function(event){
        if ( event.which == 13 ) {
            return
        }

        var $form      = $(this).closest('form'),
            $city      = $form.find('#city'),
            $cityId    = $form.find('#cityId'),
            $region    = $form.find('#region'),
            $regionId  = $form.find('#regionId'),
            $country   = $form.find('#country'),
            $countryId = $form.find('#countryId');

        $cityId.val('');

        if($regionId.val()!='' && $regionId.val()!=undefined) {
            var region = $regionId.val();
        } else if ($region.val() != undefined) {
            var region = $region.val();
        } else {
            var region = '';
        }
        $( this ).autocomplete({
            source: function (request, response) {
                $.ajax({
                    type: 'GET',
                    url: baseUrl + "?page=ajax&action=location_cities&region=" + region + "&term="+encodeURIComponent(request.term),
                success: function( data ) {
                    response( $.map( JSON.parse(data), function( item ) {
                        return {
                            label: item.label + " (" + item.region + ")",
                            value: item.label,
                            id   : item.id
                        }
                    }));
                }
                })
            },
            minLength: 2,
            search  : function(){
                $(this).parent().addClass("loader");
            },
            response    : function(){
                $cityId.val('');
                $(this).parent().removeClass("loader");
            },
            select: function( event, ui ) {
                $cityId.val(ui.item.id);
            }
        });
    });

    $('#city').keypress(handleEnterKeyPress);
    $('#region').keypress(handleEnterKeyPress);

    function handleEnterKeyPress(e) {
        var code = (e.keyCode ? e.keyCode : e.which);
        if(code == 13) { //Enter keycode
            return false;
        }
    }

    $('.ui-autocomplete').css('zIndex', 10000);

    $(document).on("change", 'select#countryId', function(){
        var $form      = $(this).closest('form'),
            $city      = $form.find('#city'),
            $cityId    = $form.find('#cityId'),
            $region    = $form.find('#region'),
            $regionId  = $form.find('#regionId'),
            $country   = $form.find('#country'),
            $countryId = $form.find('#countryId');

        var pk_c_code = $(this).val();
        var url = baseUrl + "?page=ajax&action=regions&countryId=" + pk_c_code;
        var result = '';

        if(!displayLocation && pk_c_code != '') {

            $regionId.attr('disabled',false);
            $cityId.attr('disabled',true);

            $.ajax({
                type: "POST",
                url: url,
                dataType: 'json',
                success: function(data){
                    var length = data.length;

                    if(length > 0) {

                        result += '<option value="">' + textRegion + '</option>';
                        for(key in data) {
                            result += '<option value="' + data[key].pk_i_id + '">' + data[key].s_name + '</option>';
                        }

                        $region.before('<select class="form-control" name="regionId" id="regionId" ></select>');
                        $region.remove();

                        $city.before('<select class="form-control" name="cityId" id="cityId" ></select>');
                        $city.remove();

                        $form.find('#regionId').val("");

                    } else {

                        $regionId.before('<input type="text" name="region" id="region" class="form-control" />');
                        $regionId.remove();

                        $cityId.before('<input type="text" name="city" id="city" class="form-control" />');
                        $cityId.remove();

                    }

                    $form.find('#regionId').html(result);
                    $form.find('#cityId').html('<option selected value="">' + textCity + '</option>');
                }
             });

         } else if(!displayLocation) {

             // add empty select
             $region.before('<select class="form-control" name="regionId" id="regionId" ><option value="">' + textRegion + '</option></select>');
             $region.remove();

             $city.before('<select class="form-control" name="cityId" id="cityId" ><option value="">' + textCity + '</option></select>');
             $city.remove();

             if( $regionId.length > 0 ){
                 $form.find('#regionId').html('<option value="">' + textRegion + '</option>');
             } else {
                 $region.before('<select class="form-control" name="regionId" id="regionId" ><option value="">' + textRegion + '</option></select>');
                 $region.remove();
             }
             if( $cityId.length > 0 ){
                $form.find('#cityId').html('<option value="">' + textCity + '</option>');
             } else {
                 $city.before('<select class="form-control" name="cityId" id="cityId" ><option value="">' + textCity + '</option></select>');
                 $city.remove();
             }
             $form.find('#regionId').attr('disabled',true);
             $form.find('#cityId').attr('disabled',true);
         }
    });

    $(document).on("change", 'select#regionId', function(){
        var $form      = $(this).closest('form'),
            $city      = $form.find('#city'),
            $cityId    = $form.find('#cityId'),
            $region    = $form.find('#region'),
            $regionId  = $form.find('#regionId'),
            $country   = $form.find('#country'),
            $countryId = $form.find('#countryId');

        var pk_c_code = $(this).val();
        var url = baseUrl + "?page=ajax&action=cities&regionId=" + pk_c_code;

        var result = '';

        if(!displayLocation && pk_c_code != '') {

            $cityId.attr('disabled',false);
            $.ajax({
                type: "POST",
                url: url,
                dataType: 'json',
                success: function(data){
                    var length = data.length;
                    if(length > 0) {
                        result += '<option selected value="">' + textCity + '</option>';
                        for(key in data) {
                            result += '<option value="' + data[key].pk_i_id + '">' + data[key].s_name + '</option>';
                        }

                        $city.before('<select class="form-control" name="cityId" id="cityId" ></select>');
                        $city.remove();
                    } else {
                        result += '<option value="">' + textNoResults + '</option>';
                        $cityId.before('<input type="text" name="city" id="city" class="form-control" />');
                        $cityId.remove();
                    }
                    $form.find('#cityId').html(result);
                }
             });
         } else {
            $cityId.attr('disabled',true);
         }
    });

    if( $("#regionId").attr('value') == "") {
        $("#cityId").attr('disabled',true);
    }

    if($("#countryId").length != 0) {
        if( $("#countryId").prop('type').match(/select-one/) ) {
            if( $("#countryId").attr('value') == "") {
                $("#regionId").attr('disabled',true);
            }
        }
    }
});
